/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataPort;

import jpos.JposException;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataPort.DataPort;

public class SerialDataPort
implements DataPort {
    private SerialPort dataPort = null;
    private String portName = null;
    private String baudRate = null;
    private String dataBits = null;
    private String stopBits = null;
    private String parity = null;
    private String useCTS = null;

    @Override
    public void open(String ... s) throws Exception {
        String portName = s[0];
        String baudRate = s[1];
        String dataBits = s[2];
        String stopBits = s[3];
        String parity = s[4];
        String useCTS = s[5];
        this.portName = portName;
        int _stopBits = 1;
        int _parity = 0;
        if (stopBits.equals("1.5")) {
            _stopBits = 3;
        } else if (stopBits.equals("2")) {
            _stopBits = 2;
        }
        parity = parity.toUpperCase();
        if (parity.equals("ODD")) {
            _parity = 1;
        } else if (parity.equals("EVEN")) {
            _parity = 2;
        } else if (parity.equals("MARK")) {
            _parity = 3;
        } else if (parity.equals("SPACE")) {
            _parity = 4;
        }
        try {
            String[] portNames = SerialPortList.getPortNames();
            this.dataPort = new SerialPort(portName);
            this.dataPort.openPort();
            useCTS = useCTS.toUpperCase();
            if (useCTS.equals("YES")) {
                this.dataPort.setFlowControlMode(3);
            }
            this.dataPort.setParams(Integer.parseInt(baudRate), Integer.parseInt(dataBits), _stopBits, _parity);
        }
        catch (SerialPortException ex) {
            throw new JposException(102, ex.getPortName() + " " + ex.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
        if (this.dataPort.isOpened()) {
            this.dataPort.closePort();
        }
    }

    @Override
    public void writeByte(byte b) throws Exception {
        this.dataPort.writeByte(b);
    }

    @Override
    public void writeBytes(byte[] data) throws Exception {
        this.dataPort.writeBytes(data);
    }

    @Override
    public void setFlowControlMode(int mask) throws Exception {
        this.dataPort.setFlowControlMode(mask);
    }

    @Override
    public void setParams(int baudRate, int dataBits, int stopBits, int parity) throws Exception {
        this.dataPort.setParams(baudRate, dataBits, stopBits, parity);
    }

    @Override
    public String readHexString(int byteCount) throws Exception {
        String s = this.dataPort.readHexString(byteCount);
        return s;
    }

    @Override
    public int getInputBufferBytesCount() throws Exception {
        return this.dataPort.getInputBufferBytesCount();
    }

    @Override
    public void closePort() throws Exception {
        if (this.dataPort.isOpened()) {
            this.dataPort.closePort();
        }
    }

    @Override
    public void openPort() throws Exception {
        this.dataPort.openPort();
    }
}

