/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataPort;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import jpos.JposException;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataPort.DataPort;

public class IpDataPort
implements DataPort {
    private Socket socket = null;
    private int portNumber = 0;
    private String address = "localhost";
    private BufferedInputStream bis = null;
    private BufferedOutputStream bos = null;

    @Override
    public void open(String ... s) throws Exception {
        try {
            String[] ipPortData = s[0].split(":");
            this.portNumber = Integer.valueOf(ipPortData[1]);
            this.address = ipPortData[0];
            this.socket = new Socket(this.address, this.portNumber);
            this.bis = new BufferedInputStream(this.socket.getInputStream());
            this.bos = new BufferedOutputStream(this.socket.getOutputStream());
        }
        catch (Exception ex) {
            throw new JposException(102, this.address + ":" + this.portNumber + " " + ex.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.bis != null) {
            this.bis.close();
        }
        if (this.bos != null) {
            this.bos.close();
        }
        this.portNumber = 0;
        this.socket = null;
    }

    @Override
    public void writeByte(byte b) throws Exception {
        this.bos.write(b);
    }

    @Override
    public void writeBytes(byte[] byteData) throws Exception {
        this.bos.write(byteData);
        this.bos.flush();
    }

    @Override
    public void setFlowControlMode(int mask) throws Exception {
    }

    @Override
    public void setParams(int baudRate, int dataBits, int stopBits, int parity) throws Exception {
    }

    @Override
    public String readHexString(int byteCount) throws Exception {
        return this.readHexString(byteCount, " ");
    }

    @Override
    public int getInputBufferBytesCount() throws Exception {
        return this.bis.available();
    }

    private String readHexString(int byteCount, String separator) throws Exception {
        String[] strBuffer = this.readHexStringArray(byteCount);
        String returnString = "";
        boolean insertSeparator = false;
        String[] arr = strBuffer;
        int len$ = strBuffer.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String value = arr[i$];
            if (insertSeparator) {
                returnString = returnString + separator;
            }
            returnString = returnString + value;
            insertSeparator = true;
        }
        return returnString;
    }

    private String[] readHexStringArray(int byteCount) throws Exception {
        int[] intBuffer = this.readIntArray(byteCount);
        String[] strBuffer = new String[intBuffer.length];
        for (int i = 0; i < intBuffer.length; ++i) {
            String value = Integer.toHexString(intBuffer[i]).toUpperCase();
            if (value.length() == 1) {
                value = "0" + value;
            }
            strBuffer[i] = value;
        }
        return strBuffer;
    }

    private int[] readIntArray(int byteCount) throws Exception {
        byte[] buffer = new byte[byteCount];
        this.bis.read(buffer, 0, byteCount);
        int[] intBuffer = new int[buffer.length];
        for (int i = 0; i < buffer.length; ++i) {
            intBuffer[i] = buffer[i] < 0 ? 256 + buffer[i] : buffer[i];
        }
        return intBuffer;
    }

    @Override
    public void closePort() throws Exception {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.bis != null) {
                this.bis.close();
            }
            if (this.bos != null) {
                this.bos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Thread.sleep(1000L);
    }

    @Override
    public void openPort() throws Exception {
        this.socket = new Socket(this.address, this.portNumber);
        this.bis = new BufferedInputStream(this.socket.getInputStream());
        this.bos = new BufferedOutputStream(this.socket.getOutputStream());
    }
}

