/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataExchanger;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataPort.DataPort;

public class DataWriter
extends Thread {
    private DataPort dataPort = null;
    private BlockingQueue<byte[]> dataQueue = new LinkedBlockingQueue<byte[]>();
    private long sleepTime = 10L;
    private volatile boolean iterationSuccess = false;

    public DataWriter(DataPort dataPort, long sleepTime) {
        this.dataPort = dataPort;
        this.sleepTime = sleepTime;
        this.start();
    }

    public void writeData(byte[] data) {
        this.dataQueue.add(data);
    }

    public void writeData(byte data) {
        this.dataQueue.add(new byte[]{data});
    }

    public boolean isIterationSuccess() {
        return this.iterationSuccess;
    }

    @Override
    public void run() {
        while (true) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            try {
                byte[] dataPacket = (byte[])this.dataQueue.poll();
                if (dataPacket != null) {
                    this.iterationSuccess = false;
                    this.dataPort.writeBytes(dataPacket);
                }
                this.iterationSuccess = true;
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
            }
            catch (Exception e) {
                this.iterationSuccess = false;
                Thread.currentThread().interrupt();
            }
        }
    }
}

