/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataExchanger;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataPort.DataPort;

public class DataReader
extends Thread {
    private DataPort dataPort = null;
    private BlockingQueue<String> dataQueue = new LinkedBlockingQueue<String>();
    private long sleepTime = 100L;
    private volatile boolean iterationSuccess = false;

    public DataReader(DataPort dataPort, long sleepTime) {
        this.dataPort = dataPort;
        this.sleepTime = sleepTime;
        this.start();
    }

    public String getNextDataPacket() {
        return (String)this.dataQueue.poll();
    }

    public boolean isIterationSuccess() {
        return this.iterationSuccess;
    }

    public boolean isEmpty() {
        return this.dataQueue.isEmpty();
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                this.iterationSuccess = false;
                if (this.dataPort.getInputBufferBytesCount() > 0) {
                    String nextDataPacket = this.dataPort.readHexString(1);
                    this.iterationSuccess = true;
                    if (nextDataPacket == null) continue;
                    this.dataQueue.add(nextDataPacket);
                    continue;
                }
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
            }
            catch (Exception e) {
                this.iterationSuccess = false;
                Thread.currentThread().interrupt();
            }
        }
    }
}

