/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector;

import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jpos.JposException;
import jpos.config.JposEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.Configurator;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.DataPacket;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.DriverUtil;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.PiritConnector;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.PiritExtendedErrorMsg;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.PiritFNTicket;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.PiritFnBlockStatus;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.PortConnector;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.commandData.BuyerPassportData;
import ru.crystals.pos.fiscalprinter.jpos.pirit.dataTransfer.BeginDocData;
import ru.crystals.pos.fiscalprinter.jpos.pirit.dataTransfer.CloseDocData;
import ru.crystals.pos.fiscalprinter.jpos.pirit.dataTransfer.PiritCommand;
import ru.crystals.pos.fiscalprinter.jpos.pirit.dataTransfer.RecepieData;
import ru.crystals.pos.fiscalprinter.jpos.pirit.dataTransfer.recepieData.Discount;
import ru.crystals.pos.fiscalprinter.jpos.pirit.dataTransfer.recepieData.Payment;
import ru.crystals.pos.fiscalprinter.jpos.pirit.utils.DocFromFN;
import ru.crystals.pos.fiscalprinter.jpos.pirit.utils.Pair;

public class PiritService {
    private Logger Log;
    private static PiritService instance = null;
    private PiritConnector pc = null;
    private Configurator config = new Configurator();
    private static String physicalDescription = "Fiscal Printer PIRIT";
    private static String physicalName = "Fiscal Printer PIRIT";
    private static String STATUS_TIMER = "2000";
    private static String getServiceDescription = "";
    private int countStart = 0;
    private AtomicInteger currentBufferSize = new AtomicInteger(0);
    protected boolean bEnablePacketPrint = false;
    protected boolean bEnablePrintOff = false;
    protected boolean bEnablePrintCalcUnit = false;
    protected boolean bCutReceipt = false;
    private String buyerAddress = "";
    private String userAddress = "";
    private Long differentFlags;
    private String placeCalc = "";
    private String senderEmail = "";
    private String machineNumber = "";
    private String extraUserReqName = "";
    private String extraUserReqValue = "";
    private String pokupatel = "";
    private String innPokupatelya = "";
    private BuyerPassportData buyerPassportData = new BuyerPassportData();
    private String countryCode = "";
    private String customsDeclaration = "";
    private String itemQuantityName = "";
    private String cashlessSign = "";
    private String cashlessId = "";
    private String cashlessInfo = "";
    private long readTimeOut;
    private long defReadTimeOut;
    private long oismServerTimeout = TimeUnit.SECONDS.toMillis(5L);
    private PropertyChangeListener exeptinListener = null;
    private List<PiritCommand> commandPool;
    private List<String> calculationUnit;
    private BeginDocData beginDocData;
    private CloseDocData closeDocData;
    private RecepieData recepieData;
    private long attrMarkupType = 4L;
    private long attrSubjectType = 1L;
    private long currentFirmWare = 0L;
    private Long tax;
    private String currentFirmWareID = "";
    private String loggerName;
    private FileAppender fa;
    private List<Integer> allSTLV = Arrays.asList(1059, 1068, 1084, 1129, 1130, 1131, 1132, 1133, 1145, 1146, 1157, 1158, 1174, 1194, 1223, 1224, 1163, 1291, 1256, 1260, 1145, 1146, 1232, 1233, 1261, 1270, 2007);
    private List<Integer> tagsInDoc;
    private List<Integer> decimalTags = Arrays.asList(1040, 1020, 1031, 1216, 1217, 1038, 1102, 1103, 1104, 1105, 1106, 1107, 1042, 1081, 1215, 1012, 1214, 1212, 1222, 1079, 1198, 1229, 1199, 1200, 1043, 1178, 1173, 1057, 2102, 2106, 2107, 1292, 1293, 1294, 1118, 1111, 1097, 1098, 1206, 1213, 1134, 1135, 1144, 1136, 1138, 1139, 1140, 1141, 1142, 1143, 1183, 1201, 1218, 1219, 1220, 2108, 1271, 1273, 2114);
    private List<String> rawDocInTLV;
    private DocFromFN docFromFN;
    private static final int PIRIT1F_FW = 165;
    private static final int PIRIT_BUFFER_SIZE = 2048;
    private final long MARK_CODE_VALIDATION_MODE = 0L;

    private PiritService() {
        this.commandPool = new LinkedList<PiritCommand>();
        this.calculationUnit = new LinkedList<String>();
        this.recepieData = new RecepieData();
    }

    public List<PiritCommand> getCommandPool() {
        return this.commandPool;
    }

    public BeginDocData getBeginDocData() {
        return this.beginDocData;
    }

    public CloseDocData getCloseDocData() {
        return this.closeDocData;
    }

    public void addCommandToPool(PiritCommand piritCommand) {
        this.Log.debug((Object)("addCommandToPool: " + piritCommand));
        this.commandPool.add(piritCommand);
    }

    public void removeCommandFromPool(PiritCommand piritCommand) {
        this.Log.debug((Object)("removeCommandFromPool: " + piritCommand));
        this.commandPool.remove(piritCommand);
    }

    public void clearCommandPool() {
        this.Log.debug((Object)"clearCommandToPool");
        this.commandPool.clear();
    }

    public static PiritService newInstance() {
        return new PiritService();
    }

    public void setAttrMarkupType(long attrMarkupType) {
        this.attrMarkupType = attrMarkupType;
    }

    public void setAttrSubjectType(long attrSubjectType) {
        this.attrSubjectType = attrSubjectType;
    }

    public void setbEnablePrintCalcUnit(boolean bEnablePrintCalcUnit) {
        this.bEnablePrintCalcUnit = bEnablePrintCalcUnit;
    }

    public long getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public long getDefReadTimeOut() {
        return PiritConnector.getDefReadTimeOut();
    }

    public void setDefReadTimeOut(long defReadTimeOut) {
        PiritConnector.setDefReadTimeOut(defReadTimeOut);
    }

    public long getOismServerTimeout() {
        return this.oismServerTimeout;
    }

    public void setOismServerTimeout(long oismServerTimeout) {
        this.Log.debug((Object)("setOismServerTimeout is(" + oismServerTimeout + ")"));
        this.oismServerTimeout = oismServerTimeout;
    }

    public boolean isbEnablePacketPrint() {
        return this.bEnablePacketPrint;
    }

    public void setbEnablePacketPrint(boolean bEnablePacketPrint) {
        this.bEnablePacketPrint = bEnablePacketPrint;
        if (this.pc != null) {
            this.pc.setPacketPrint(bEnablePacketPrint);
        }
    }

    public boolean isbEnablePrintOff() {
        return this.bEnablePrintOff;
    }

    public void setbEnablePrintOff(boolean bEnablePrintOff) {
        this.bEnablePrintOff = bEnablePrintOff;
    }

    public boolean isbCutReceipt() {
        return this.bCutReceipt;
    }

    public void setbCutReceipt(boolean bCutReceipt) {
        this.bCutReceipt = bCutReceipt;
    }

    public static synchronized PiritService getInstance() {
        if (instance == null) {
            instance = new PiritService();
        }
        return instance;
    }

    public void initLogger(String loggerName, FileAppender fa) {
        this.loggerName = loggerName;
        this.fa = fa;
        this.Log = Logger.getLogger((String)(loggerName + " " + this.getClass().getName()));
        this.Log.setLevel(Level.INFO);
        this.Log.addAppender((Appender)fa);
    }

    public void setExeptinListener(PropertyChangeListener exeptinListener) {
        this.exeptinListener = exeptinListener;
    }

    public void setBuyerAddress(String buyerAddress) {
        this.Log.debug((Object)("setBuyerAddress is(" + buyerAddress + ")"));
        this.buyerAddress = buyerAddress;
    }

    public void setUserAddress(String userAddress) {
        this.Log.debug((Object)("setUserAddress is(" + userAddress + ")"));
        this.userAddress = userAddress;
    }

    public void setTax(Long tax) {
        this.Log.debug((Object)("setTax is(" + tax + ")"));
        this.tax = tax;
    }

    public void setDifferentFlags(long differentFlags) {
        this.Log.debug((Object)("setDifferentFlags is(" + differentFlags + ")"));
        this.differentFlags = differentFlags;
    }

    public void setPlaceCalc(String placeCalc) {
        this.Log.debug((Object)("setPlaceCalc is(" + placeCalc + ")"));
        this.placeCalc = placeCalc;
    }

    public void setSenderEmail(String senderEmail) {
        this.Log.debug((Object)("setSenderEmail is(" + senderEmail + ")"));
        this.senderEmail = senderEmail;
    }

    public void setMachineNumber(String machineNumber) {
        this.Log.debug((Object)("setMachineNumber is(" + machineNumber + ")"));
        this.machineNumber = machineNumber;
    }

    public void setExtraUserReqName(String extraUserReqName) {
        this.Log.debug((Object)("setExtraUserReqName is(" + extraUserReqName + ")"));
        this.extraUserReqName = extraUserReqName;
    }

    public void setExtraUserReqValue(String extraUserReqValue) {
        this.Log.debug((Object)("setExtraUserReqValue is(" + extraUserReqValue + ")"));
        this.extraUserReqValue = extraUserReqValue;
    }

    public void setPokupatel(String pokupatel) {
        this.Log.debug((Object)("setPokupatel is(" + pokupatel + ")"));
        this.pokupatel = pokupatel;
    }

    public void setInnPokupatelya(String innPokupatelya) {
        this.Log.debug((Object)("setInnPokupatelya is(" + innPokupatelya + ")"));
        this.innPokupatelya = innPokupatelya;
    }

    public BuyerPassportData getBuyerPassportData() {
        return this.buyerPassportData;
    }

    public void setCountryCode(String countryCode) {
        this.Log.debug((Object)("setCountryCode is(" + countryCode + ")"));
        this.countryCode = countryCode;
    }

    public void setCustomsDeclaration(String customsDeclaration) {
        this.Log.debug((Object)("setCustomsDeclaration is(" + customsDeclaration + ")"));
        this.customsDeclaration = customsDeclaration;
    }

    public void setItemQuantityName(String itemQuantityName) {
        this.Log.debug((Object)("setItemQuantityName is(" + itemQuantityName + ")"));
        this.itemQuantityName = itemQuantityName;
    }

    public void setCashlessSign(String cashlessSign) {
        this.Log.debug((Object)("setCashlessSign is(" + cashlessSign + ")"));
        this.cashlessSign = cashlessSign;
    }

    public void setCashlessId(String cashlessId) {
        this.Log.debug((Object)("setCashlessId is(" + cashlessId + ")"));
        this.cashlessId = cashlessId;
    }

    public void setCashlessInfo(String cashlessInfo) {
        this.Log.debug((Object)("setCashlessInfo is(" + cashlessInfo + ")"));
        this.cashlessInfo = cashlessInfo;
    }

    public void setTagsInDoc(List<Integer> tagsInDoc) {
        this.Log.debug((Object)("setTagsInDoc is(" + tagsInDoc.toString() + ")"));
        this.tagsInDoc = tagsInDoc;
    }

    public List<Integer> getTagsInDoc() {
        return this.tagsInDoc;
    }

    private void setDocFromFN(DocFromFN docFromFN) {
        this.Log.debug((Object)("Save doc \u2116 " + docFromFN.getValue(1040)));
        this.docFromFN = docFromFN;
    }

    public DocFromFN getDocFromFN() {
        return this.docFromFN;
    }

    private void setRawDocInTLV(List<String> listRawTLV) {
        this.Log.debug((Object)("setRawDocInTLV is(" + listRawTLV.toString() + ")"));
        this.rawDocInTLV = listRawTLV;
    }

    public List<String> getRawDocInTLV() {
        return this.rawDocInTLV;
    }

    public static String getStatusTimer() {
        return STATUS_TIMER;
    }

    public void readConfig(JposEntry jposEntry) {
        String password;
        String depart;
        String useCTS;
        String parity;
        String stopBits;
        String dataBits;
        String baudRate;
        String portName;
        JposEntry.Prop prop = jposEntry.getProp("productDescription");
        if (prop != null) {
            physicalDescription = prop.getValueAsString();
        }
        if ((prop = jposEntry.getProp("productName")) != null) {
            physicalName = prop.getValueAsString();
        }
        if ((prop = jposEntry.getProp("serviceDescription")) != null) {
            getServiceDescription = prop.getValueAsString();
        }
        if ((prop = jposEntry.getProp("port")) != null && (portName = prop.getValueAsString()).length() > 0) {
            this.config.setPortName(prop.getValueAsString());
        }
        if ((prop = jposEntry.getProp("baudRate")) != null && (baudRate = prop.getValueAsString()).length() > 0) {
            this.config.setBaudRate(baudRate);
        }
        if ((prop = jposEntry.getProp("dataBits")) != null && (dataBits = prop.getValueAsString()).length() > 0) {
            this.config.setDataBits(dataBits);
        }
        if ((prop = jposEntry.getProp("stopBits")) != null && (stopBits = prop.getValueAsString()).length() > 0) {
            this.config.setStopBits(stopBits);
        }
        if ((prop = jposEntry.getProp("parity")) != null && (parity = prop.getValueAsString()).length() > 0) {
            this.config.setParity(parity);
        }
        if ((prop = jposEntry.getProp("useCTS")) != null && (useCTS = prop.getValueAsString()).length() > 0) {
            this.config.setUseCTS(useCTS);
        }
        if ((prop = jposEntry.getProp("depart")) != null && (depart = prop.getValueAsString()).length() > 0) {
            this.config.setDepart(depart);
        }
        if ((prop = jposEntry.getProp("password")) != null && (password = prop.getValueAsString()).length() > 0) {
            this.config.setPassword(password);
        }
        if ((prop = jposEntry.getProp("statusTimer")) != null) {
            String statusTimer = prop.getValueAsString();
            if (statusTimer.length() > 0) {
                this.config.setStatusTimer(prop.getValueAsString());
            }
            STATUS_TIMER = prop.getValueAsString();
        }
    }

    public synchronized boolean start() throws Exception {
        if (this.countStart == 0) {
            if (this.pc != null) {
                this.pc.close();
            }
            try {
                this.pc = new PiritConnector(this.loggerName, this.fa, this.readTimeOut);
                this.pc.addListener(this.exeptinListener);
                PortConnector portConnector = new PortConnector(this.config.getPortName(), this.config.getBaudRate(), this.config.getDataBits(), this.config.getStopBits(), this.config.getParity(), this.config.getUseCTS());
                this.pc.open(portConnector);
                this.countStart = 1;
                this.startWork();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public synchronized void stop() throws Exception {
        if (this.countStart == 1) {
            this.pc.close();
        }
        this.countStart = 0;
    }

    public synchronized void startWork() throws Exception {
        this.pc.SendPacket(0, "");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(0));
        boolean needStartCmd = PiritService.getBit(dp.getLongValue(1), 0);
        if (needStartCmd) {
            dp = new DataPacket();
            dp.putDateValue(new Date());
            dp.putTimeValue(new Date());
            this.pc.SendPacket(16, dp.getDataBuffer());
            this.pc.ReadPacket(16);
        }
    }

    public synchronized boolean isConnect() {
        try {
            this.pc.SendPacket(0, "");
            this.pc.ReadPacket(0);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized boolean isShiftOpen() throws Exception {
        this.pc.SendPacket(0, "");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(0));
        long lVal = dp.getLongValue(1);
        return PiritService.getBit(lVal, 2);
    }

    public synchronized String getPrinterState() throws Exception {
        int docState;
        int docType;
        int curState;
        StringBuilder result = new StringBuilder();
        this.pc.SendPacket(0, "");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(0));
        int fatalStatus = (int)dp.getLongValue(0);
        if (PiritService.getBit(fatalStatus, 0)) {
            result.append("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 NVR\n");
        }
        if (PiritService.getBit(fatalStatus, 1)) {
            result.append("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438\n");
        }
        if (PiritService.getBit(fatalStatus, 2)) {
            result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u0441 \u0424\u041f\n");
        }
        if (PiritService.getBit(fatalStatus, 3)) {
            result.append("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438\n");
        }
        if (PiritService.getBit(fatalStatus, 4)) {
            result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u043f\u0430\u043c\u044f\u0442\u044c\n");
        }
        if (PiritService.getBit(fatalStatus, 5)) {
            result.append("\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u043d\n");
        }
        if (PiritService.getBit(fatalStatus, 6)) {
            result.append("\u0424\u0430\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u042d\u041a\u041b\u0417\n");
        }
        if (PiritService.getBit(fatalStatus, 7)) {
            result.append("\u0420\u0430\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0424\u0420 \u0438 \u042d\u041a\u041b\u0417\n");
        }
        if (PiritService.getBit(curState = (int)dp.getLongValue(1), 0)) {
            result.append("\u041d\u0435 \u0431\u044b\u043b\u0430 \u0432\u044b\u0437\u0432\u0430\u043d\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u044f '\u041d\u0430\u0447\u0430\u043b\u043e \u0440\u0430\u0431\u043e\u0442\u044b'\n");
        }
        if (PiritService.getBit(curState, 1)) {
            result.append("\u041d\u0435\u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c\n");
        }
        if (PiritService.getBit(curState, 2)) {
            result.append("\u0421\u043c\u0435\u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430\n");
        }
        if (PiritService.getBit(curState, 3)) {
            result.append("\u0421\u043c\u0435\u043d\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 24 \u0447\u0430\u0441\u043e\u0432\n");
        }
        if (PiritService.getBit(curState, 4)) {
            result.append("\u0410\u0440\u0445\u0438\u0432 \u042d\u041a\u041b\u0417 \u0437\u0430\u043a\u0440\u044b\u0442\n");
        }
        if (PiritService.getBit(curState, 5)) {
            result.append("\u042d\u041a\u041b\u0417 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430\n");
        }
        if (PiritService.getBit(curState, 6)) {
            result.append("\u041d\u0435\u0442 \u043f\u0430\u043c\u044f\u0442\u0438 \u0434\u043b\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043c\u0435\u043d\u044b \u0432 \u0424\u041f\n");
        }
        if (PiritService.getBit(curState, 7)) {
            result.append("\u0411\u044b\u043b \u0432\u0432\u0435\u0434\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0424\u041f\n");
        }
        if (PiritService.getBit(curState, 8)) {
            result.append("\u041d\u0435 \u0431\u044b\u043b\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e\n");
        }
        if (PiritService.getLowHalfByte(docType = (int)dp.getLongValue(2)) == 0) {
            result.append("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0437\u0430\u043a\u0440\u044b\u0442\n");
        }
        if (PiritService.getLowHalfByte(docType) == 1) {
            result.append("\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\n");
        }
        if (PiritService.getLowHalfByte(docType) == 2) {
            result.append("\u0427\u0435\u043a \u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0443 (\u043f\u0440\u0438\u0445\u043e\u0434)\n");
        }
        if (PiritService.getLowHalfByte(docType) == 3) {
            result.append("\u0427\u0435\u043a \u043d\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 (\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u043f\u0440\u0438\u0445\u043e\u0434\u0430)\n");
        }
        if (PiritService.getLowHalfByte(docType) == 4) {
            result.append("\u0412\u043d\u0435\u0441\u0435\u043d\u0438\u0435 \u0432 \u043a\u0430\u0441\u0441\u0443");
        }
        if (PiritService.getLowHalfByte(docType) == 5) {
            result.append("\u0418\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f\n");
        }
        if (PiritService.getLowHalfByte(docType) == 6) {
            result.append("\u0427\u0435\u043a \u043d\u0430 \u043f\u043e\u043a\u0443\u043f\u043a\u0443 (\u0440\u0430\u0441\u0445\u043e\u0434)\n");
        }
        if (PiritService.getLowHalfByte(docType) == 7) {
            result.append("\u0427\u0435\u043a \u043d\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u043f\u043e\u043a\u0443\u043f\u043a\u0438 (\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0440\u0430\u0441\u0445\u043e\u0434\u0430)\n");
        }
        if (PiritService.getHighHalfByte(docState = (int)dp.getLongValue(2)) == 0) {
            result.append("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0437\u0430\u043a\u0440\u044b\u0442\n");
        }
        if (PiritService.getHighHalfByte(docState) == 1) {
            result.append("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e\u0442\u043a\u0440\u044b\u0442/\u0432\u0432\u043e\u0434 \u043f\u043e\u0437\u0438\u0446\u0438\u0439\n");
        }
        if (PiritService.getHighHalfByte(docState) == 2) {
            result.append("\u0412\u0432\u043e\u0434 \u0441\u043a\u0438\u0434\u043a\u0438 \u043d\u0430 \u0447\u0435\u043a\n");
        }
        if (PiritService.getHighHalfByte(docState) == 3) {
            result.append("\u0412\u0432\u043e\u0434 \u043e\u043f\u043b\u0430\u0442\u044b\n");
        }
        if (PiritService.getHighHalfByte(docState) == 4) {
            result.append("\u0420\u0430\u0441\u0447\u0435\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\n");
        }
        if (PiritService.getHighHalfByte(docState) == 8) {
            result.append("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0437\u0430\u043a\u0440\u044b\u0442 \u0432 \u0424\u041d\n");
        }
        this.pc.SendPacket(4, "");
        dp = new DataPacket(this.pc.ReadPacket(4));
        int printerState = (int)dp.getLongValue(0);
        if (PiritService.getBit(printerState, 0)) {
            result.append("\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u043d\u0435 \u0433\u043e\u0442\u043e\u0432\n");
        }
        if (PiritService.getBit(printerState, 1)) {
            result.append("\u0412 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0435 \u043d\u0435\u0442 \u0431\u0443\u043c\u0430\u0433\u0438\n");
        }
        if (PiritService.getBit(printerState, 2)) {
            result.append("\u041e\u0442\u043a\u0440\u044b\u0442\u0430 \u043a\u0440\u044b\u0448\u043a\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430\n");
        }
        if (PiritService.getBit(printerState, 3)) {
            result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0437\u0447\u0438\u043a\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430\n");
        }
        if (PiritService.getBit(printerState, 7)) {
            result.append("\u041d\u0435\u0442 \u0441\u0432\u044f\u0437\u0438 \u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u043e\u043c\n");
        }
        return result.toString();
    }

    public synchronized String getAddErrorInfo() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        this.pc.SendPacket(6, "1");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(6));
        int printerState = (int)dp.getLongValue(1);
        stringBuilder.append("FR state - " + PiritExtendedErrorMsg.getPiritExtendedErrorMsg(printerState));
        this.pc.SendPacket(6, "2");
        dp = new DataPacket(this.pc.ReadPacket(6));
        printerState = (int)dp.getLongValue(1);
        stringBuilder.append("\nFN state - " + PiritFnBlockStatus.gePiritFnBlockStatusMsg(printerState));
        return stringBuilder.toString();
    }

    public synchronized boolean isPaperOut() throws Exception {
        this.pc.SendPacket(4, "");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(4));
        int printerState = (int)dp.getLongValue(0);
        return PiritService.getBit(printerState, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getPrinterStatus() throws Exception {
        DataPacket dp;
        PiritConnector piritConnector = this.pc;
        synchronized (piritConnector) {
            this.pc.SendPacket(4, "");
            dp = new DataPacket(this.pc.ReadPacket(4, 2000L));
        }
        return dp.getLongValue(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long resetHardware() throws Exception {
        DataPacket dp;
        PiritConnector piritConnector = this.pc;
        synchronized (piritConnector) {
            this.pc.SendPacket(156, "");
            dp = new DataPacket(this.pc.ReadPacket(156));
        }
        return dp.getLongValue(0);
    }

    public synchronized void beginSales(int typeDoc, String cashier, long checkNumber) throws Exception {
        this.beginSales(typeDoc, cashier, checkNumber, this.getDefReadTimeOut());
    }

    public synchronized void beginSales(int typeDoc, String cashier, long checkNumber, long readTimeout) throws Exception {
        this.closeDocData = null;
        DataPacket dp = new DataPacket();
        dp.putLongValue(Long.valueOf(typeDoc));
        dp.putLongValue(Long.parseLong(this.config.getDepart()));
        dp.putStringValue(cashier);
        dp.putLongValue(checkNumber);
        dp.putLongValue(this.tax);
        dp.putStringValue(this.userAddress);
        this.startWork();
        this.pc.SendPacket(48, dp.getDataBuffer());
        this.pc.ReadPacket(48, readTimeout);
        this.beginDocData = new BeginDocData(typeDoc, 1, cashier, checkNumber, 1);
        this.recepieData = new RecepieData();
        this.currentBufferSize.set(0);
        this.userAddress = "";
        this.tax = null;
    }

    public synchronized void resetDoc() throws Exception {
        boolean openDoc;
        this.pc.SendPacket(0, "");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(0));
        long stateDocument = dp.getLongValue(2);
        boolean errorCloseDoc = (stateDocument & 0x80L) == 128L;
        boolean bl = openDoc = (stateDocument & 0xFL) > 0L;
        if (errorCloseDoc) {
            if (!this.buyerAddress.equals("")) {
                DataPacket dpBuyerAddress = new DataPacket();
                dpBuyerAddress.putStringValue(this.buyerAddress);
                this.pc.SendPacket(49, dpBuyerAddress.getDataBuffer());
                this.pc.ReadPacket(49);
                this.closeDocData = null;
                this.buyerAddress = "";
            } else {
                this.pc.SendPacket(49, "");
                this.pc.ReadPacket(49);
                this.closeDocData = null;
                this.buyerAddress = "";
            }
        } else if (openDoc) {
            this.pc.SendPacket(50, "");
            this.pc.ReadPacket(50);
            this.closeDocData = null;
            this.buyerAddress = "";
        }
    }

    public synchronized void setTrailerLine(int lineNumber, String text) throws Exception {
        this.setStrValueTableSettings(31L, lineNumber, text);
    }

    public synchronized void setHeaderLine(int lineNumber, String text) throws Exception {
        this.setStrValueTableSettings(30L, lineNumber, text);
    }

    public synchronized String getDate() throws Exception {
        this.pc.SendPacket(19, "");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(19));
        return dp.getDateValueFullFormat();
    }

    public synchronized void cutPaperNow() throws Exception {
        this.pc.SendPacket(52, "");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(52));
    }

    public synchronized void setDate(String sdate) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyyyyHHmm");
        Date date = df.parse(sdate);
        DataPacket dp = new DataPacket();
        dp.putDateValue(date);
        dp.putTimeValue(date);
        this.pc.SendPacket(20, dp.getDataBuffer());
        this.pc.ReadPacket(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DataPacket getDataFromPirit(int command, long req) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(req);
        PiritConnector piritConnector = this.pc;
        synchronized (piritConnector) {
            this.Log.debug((Object)("getDataFromPirit start : command - " + command + " req - " + req));
            this.pc.SendPacket(command, dp.getDataBuffer());
            dp = new DataPacket(this.pc.ReadPacket(command));
            this.Log.debug((Object)"getDataFromPirit: end ");
        }
        return dp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DataPacket execCommand(int command, DataPacket dp, boolean response) throws Exception {
        DataPacket responseDP = new DataPacket();
        PiritConnector piritConnector = this.pc;
        synchronized (piritConnector) {
            this.Log.debug((Object)("execCommand start: command - " + command + " DataPacket - " + dp.toString()));
            this.pc.SendPacket(command, dp.getDataBuffer());
            if (response) {
                responseDP = new DataPacket(this.pc.ReadPacket(command));
            }
            this.Log.debug((Object)"execCommand end");
        }
        return responseDP;
    }

    public synchronized long getFirmWare() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 2L);
        this.currentFirmWare = dp.getLongValue(1);
        this.Log.debug((Object)("set currentFirmWare is : " + this.currentFirmWare));
        return this.currentFirmWare;
    }

    public synchronized String getFirmWareID() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 70L);
        this.currentFirmWareID = dp.getStringValue(1);
        this.Log.debug((Object)("set currentFirmWareID is : " + this.currentFirmWareID));
        return this.currentFirmWareID;
    }

    public synchronized String getRegNumberFR() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 4L);
        return dp.getStringValue(1);
    }

    public synchronized String getInnNumber() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 3L);
        return dp.getStringValue(1);
    }

    public synchronized String getModelDevice() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 21L);
        return dp.getStringValue(1);
    }

    public synchronized String getPrinterId() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 1L);
        return dp.getStringValue(1);
    }

    public synchronized String getNextThroughDocNumber() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 8L);
        return dp.getStringValue(1);
    }

    public synchronized Date getEndDateTimeResouarcePrinter() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 14L);
        return dp.getDateValue(1);
    }

    public synchronized Date getDateTimeOfOpenShift() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 17L);
        return dp.getDateValue(1);
    }

    public synchronized String getDateAndCorrectTimeOfOpenShift() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 17L);
        return dp.getDateValueShiftFormat();
    }

    public synchronized String getDateAndTimeOfLastFiscalOpeartion() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 5L);
        return dp.getDateValueShiftEndFormat();
    }

    public synchronized String getOperationMode() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 23L);
        return dp.getStringValue(2);
    }

    public synchronized void setTestMode(boolean mode) throws Exception {
        this.pc.setTestMode(mode);
    }

    public synchronized boolean isTestMode() throws Exception {
        return this.pc.isTestMode();
    }

    public synchronized long getNumberOfCurretnShift() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 1L);
        long lRes = dp.getLongValue(1);
        return lRes;
    }

    public synchronized String getTagValue(long docNumber, int tag) throws Exception {
        List<String> listTLV = this.getListTagValues(docNumber, tag);
        if (listTLV.isEmpty()) {
            return "";
        }
        return listTLV.get(0);
    }

    public synchronized List<String> getListTagValues(long docNumber, int tag) throws Exception {
        if (this.docFromFN != null && Long.parseLong(this.docFromFN.getValue(1040)) == docNumber) {
            return this.docFromFN.getValues(tag);
        }
        return this.getDocFromFN(docNumber).getValues(tag);
    }

    public synchronized Map<Integer, Object> getMapValue(long docNumber, int tag) throws Exception {
        List<Map<Integer, Object>> listSTLV = this.getMapTagValues(docNumber, tag);
        if (listSTLV.isEmpty()) {
            return null;
        }
        return listSTLV.get(0);
    }

    public synchronized List<Map<Integer, Object>> getMapTagValues(long docNumber, int tag) throws Exception {
        if (this.docFromFN != null && Long.parseLong(this.docFromFN.getValue(1040)) == docNumber) {
            return this.docFromFN.getSTLV(tag);
        }
        return this.getDocFromFN(docNumber).getSTLV(tag);
    }

    public synchronized DocFromFN getDocFromFN(long docNumber) throws Exception {
        Thread.sleep(2000L);
        DocFromFN docFromFN = new DocFromFN();
        DataPacket dp = new DataPacket();
        String strSize = "";
        String docTLVresult = "";
        dp.putLongValue(15L);
        dp.putLongValue(docNumber);
        this.pc.SendPacket(120, dp.getDataBuffer());
        docTLVresult = this.pc.ReadPacket(120);
        dp = new DataPacket();
        dp.putLongValue(16L);
        dp.putLongValue(docNumber);
        ArrayList<String> listRawTLV = new ArrayList<String>();
        ArrayList<Integer> listTags = new ArrayList<Integer>();
        try {
            for (int i = 0; i >= 0; ++i) {
                this.pc.SendPacket(120, dp.getDataBuffer());
                docTLVresult = this.pc.ReadPacket(120);
                listRawTLV.add(docTLVresult);
                int tag = Integer.parseInt(DriverUtil.hexToDecimal(DriverUtil.revertHEX(docTLVresult.substring(0, 4))));
                listTags.add(tag);
                strSize = DriverUtil.hexToDecimal(DriverUtil.revertHEX(docTLVresult.substring(4, 8)));
                Pair<Integer, Object> pairTLV = new Pair<Integer, Object>();
                if (tag == 1054 || tag == 1055 || tag == 1209) {
                    pairTLV.put(tag, docTLVresult.substring(8, 8 + Integer.valueOf(strSize) * 2));
                } else if (this.decimalTags.contains(tag)) {
                    pairTLV.put(tag, DriverUtil.hexToDecimal(DriverUtil.revertHEX3(docTLVresult.substring(8, 8 + Integer.valueOf(strSize) * 2))));
                } else if (tag == 1077) {
                    pairTLV.put(tag, DriverUtil.fpdHexToDecimal(docTLVresult.substring(12, 8 + Integer.valueOf(strSize) * 2)));
                } else if (this.allSTLV.contains(tag)) {
                    pairTLV.put(tag, this.getListOfPairFromSTLV(docTLVresult));
                } else {
                    pairTLV.put(tag, new String(DriverUtil.unHex(docTLVresult.substring(8, 8 + Integer.valueOf(strSize) * 2)).getBytes(StandardCharsets.ISO_8859_1), "CP866"));
                }
                docFromFN.add(pairTLV);
            }
        }
        catch (Exception e) {
            this.Log.debug((Object)("Catch Exception: " + e.getMessage()));
        }
        this.setDocFromFN(docFromFN);
        this.setRawDocInTLV(listRawTLV);
        this.setTagsInDoc(listTags);
        return docFromFN;
    }

    public synchronized List<Pair> getListOfPairFromSTLV(String docTLVresult) throws Exception {
        docTLVresult = docTLVresult.substring(8);
        ArrayList<Pair> listOfPair = new ArrayList<Pair>();
        while (docTLVresult.length() > 0) {
            int tag = Integer.parseInt(DriverUtil.hexToDecimal(DriverUtil.revertHEX(docTLVresult.substring(0, 4))));
            int length = Integer.parseInt(DriverUtil.hexToDecimal(DriverUtil.revertHEX(docTLVresult.substring(4, 8))));
            String parsedValue = "";
            if (this.allSTLV.contains(tag)) {
                listOfPair.add(new Pair<Integer, List<Pair>>(tag, this.getSubListOfPair(tag, length, docTLVresult)));
            } else {
                String value = docTLVresult.substring(8, 8 + length * 2);
                if (tag == 1023) {
                    int exponent = Integer.parseInt(value.substring(0, 2));
                    int quantity = Integer.parseInt(DriverUtil.hexToDecimal(DriverUtil.revertHEX3(value.substring(2, length * 2))));
                    double result = (double)quantity / Math.pow(10.0, exponent);
                    parsedValue = "" + result;
                } else {
                    parsedValue = tag == 1162 ? value : (this.decimalTags.contains(tag) ? DriverUtil.hexToDecimal(DriverUtil.revertHEX3(value)) : new String(DriverUtil.unHex(value).getBytes(StandardCharsets.ISO_8859_1), "CP866"));
                }
                listOfPair.add(new Pair<Integer, String>(tag, parsedValue));
            }
            docTLVresult = docTLVresult.substring(8 + length * 2);
        }
        return listOfPair;
    }

    private synchronized List<Pair> getSubListOfPair(int tag, int length, String docTLVresult) throws UnsupportedEncodingException {
        String parsedValue = "";
        String tempString = docTLVresult.substring(8, 8 + length * 2);
        ArrayList<Pair> subListOfPair = new ArrayList<Pair>();
        while (tempString.length() > 0) {
            int sTag = Integer.parseInt(DriverUtil.hexToDecimal(DriverUtil.revertHEX(tempString.substring(0, 4))));
            int sLength = Integer.parseInt(DriverUtil.hexToDecimal(DriverUtil.revertHEX(tempString.substring(4, 8))));
            if (this.allSTLV.contains(sTag)) {
                subListOfPair.add(new Pair<Integer, List<Pair>>(sTag, this.getSubListOfPair(sTag, sLength, tempString)));
            } else {
                String sValue = tempString.substring(8, 8 + sLength * 2);
                parsedValue = this.decimalTags.contains(sTag) ? DriverUtil.hexToDecimal(DriverUtil.revertHEX3(sValue)) : new String(DriverUtil.unHex(sValue).getBytes(StandardCharsets.ISO_8859_1), "CP866");
                subListOfPair.add(new Pair<Integer, String>(sTag, parsedValue));
            }
            tempString = tempString.substring(8 + sLength * 2);
        }
        return subListOfPair;
    }

    public synchronized long getAmountReceiptsOfCurretnShift() throws Exception {
        DataPacket dp = this.getDataFromPirit(1, 7L);
        long lRes1 = dp.getLongValue(1);
        long lRes2 = dp.getLongValue(2);
        long lRes3 = dp.getLongValue(3);
        long lRes4 = dp.getLongValue(4);
        long lRes5 = dp.getLongValue(5);
        long lRes6 = dp.getLongValue(6);
        long lRes = lRes1 + lRes2 + lRes3 + lRes4 + lRes5 + lRes6;
        return lRes;
    }

    public synchronized long getDailyTotal(int type) throws Exception {
        this.Log.debug((Object)("begin getDailyTotal(" + type + ")"));
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 3L);
        long result = 0L;
        if (type == 0) {
            for (int i = 0; i < 16; ++i) {
                result += dp.getLongValue(1 + i);
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                if (type != i) continue;
                result += dp.getLongValue(1 + i);
            }
        }
        this.Log.debug((Object)("end getDailyTotal:" + result));
        return result;
    }

    public synchronized long getCountVoidReceipts() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 7L);
        return dp.getLongValue(3);
    }

    public synchronized long getCountFiscalReceipts(int num) throws Exception {
        long lRes;
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 7L);
        switch (num) {
            case 0: {
                lRes = this.getLastFiscalNumberDoc();
                break;
            }
            case 1: {
                lRes = this.getLastFiscalNumberDoc();
                break;
            }
            case 2: {
                lRes = 0L;
                break;
            }
            case 3: {
                lRes = dp.getLongValue(3);
                break;
            }
            case 4: {
                lRes = dp.getLongValue(2);
                break;
            }
            case 5: {
                lRes = dp.getLongValue(5);
                break;
            }
            case 6: {
                lRes = dp.getLongValue(6);
                break;
            }
            default: {
                lRes = dp.getLongValue(1) + dp.getLongValue(2);
            }
        }
        return lRes;
    }

    public synchronized long getDailyRefundTotal() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 5L);
        long result = 0L;
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            result += dp.getLongValue(1 + i);
        }
        return result;
    }

    public synchronized long getGrandTotalSums() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 12L);
        long lRes = dp.getLongValue(1);
        return lRes;
    }

    public synchronized long getGrandTotalOutSums() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(2, 12L);
        long lRes = dp.getLongValue(2);
        return lRes;
    }

    public synchronized long getCountFiscalSaleReceipts() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 7L);
        return dp.getLongValue(1);
    }

    public synchronized long getDiscountDailyTotal() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 9L);
        return dp.getLongValue(1);
    }

    public synchronized long getReceiptTotal() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(3, 1L);
        return dp.getLongValue(1);
    }

    public synchronized long getDiscountReceiptTotal() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(3, 1L);
        return dp.getLongValue(2);
    }

    public synchronized long getSurchargeReceiptTotal() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(3, 1L);
        return dp.getLongValue(3);
    }

    public synchronized long getSurchargeDailyTotal() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 9L);
        return dp.getLongValue(2);
    }

    public synchronized long getVatSum() throws Exception {
        int i;
        long result = 0L;
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 10L);
        for (i = 1; i > 7; ++i) {
            result += dp.getLongValue(i);
        }
        dp = this.getDataFromPirit(1, 11L);
        for (i = 1; i > 7; ++i) {
            result += dp.getLongValue(i);
        }
        return result;
    }

    public synchronized long getVatInSumIndex(int index) throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 10L);
        return dp.getLongValue(index);
    }

    public synchronized long getVatOutSumIndex(int index) throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 11L);
        return dp.getLongValue(index);
    }

    public synchronized long getTypeFiscalReceipt() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(3, 2L);
        return dp.getLongValue(1);
    }

    public synchronized long getShiftNumber() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 1L);
        return dp.getLongValue(1);
    }

    public synchronized long getCashAmount(int num) throws Exception {
        DataPacket dp = new DataPacket();
        long res = 0L;
        switch (num) {
            case 112: {
                dp = this.getDataFromPirit(1, 12L);
                res = dp.getLongValue(5);
                break;
            }
            case 113: {
                dp = this.getDataFromPirit(1, 12L);
                res = dp.getLongValue(7);
                break;
            }
            case 114: {
                dp = this.getDataFromPirit(1, 16L);
                res = 0L;
                for (int i = 1; i <= 16; ++i) {
                    res += dp.getLongValue(i);
                }
                break;
            }
            case 115: {
                dp = this.getDataFromPirit(1, 17L);
                res = 0L;
                for (int i = 1; i <= 16; ++i) {
                    res += dp.getLongValue(i);
                }
                break;
            }
            case 212: {
                dp = this.getDataFromPirit(2, 12L);
                res = dp.getLongValue(1);
                break;
            }
            case 213: {
                dp = this.getDataFromPirit(2, 12L);
                res = dp.getLongValue(2);
                break;
            }
            case 214: {
                dp = this.getDataFromPirit(2, 12L);
                res = dp.getLongValue(3);
                break;
            }
            case 215: {
                dp = this.getDataFromPirit(2, 12L);
                res = dp.getLongValue(4);
                break;
            }
            case 121: {
                dp = this.getDataFromPirit(1, 3L);
                res = 0L;
                for (int i = 1; i <= 16; ++i) {
                    res += dp.getLongValue(i);
                }
                break;
            }
            case 123: {
                dp = this.getDataFromPirit(1, 5L);
                res = 0L;
                for (int i = 1; i <= 16; ++i) {
                    res += dp.getLongValue(i);
                }
                break;
            }
            case 185: {
                dp = this.getDataFromPirit(1, 9L);
                res = dp.getLongValue(1);
                break;
            }
            case 187: {
                dp = this.getDataFromPirit(1, 9L);
                res = dp.getLongValue(3);
                break;
            }
            case 193: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(1);
                break;
            }
            case 197: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(2);
                break;
            }
            case 198: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(3);
                break;
            }
            case 201: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(15);
                break;
            }
            case 202: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(4);
                break;
            }
            case 195: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(1);
                break;
            }
            case 199: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(2);
                break;
            }
            case 203: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(3);
                break;
            }
            case 205: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(16);
                break;
            }
            case 206: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(5);
                break;
            }
            case 207: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(16);
                break;
            }
            case 220: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(4);
                break;
            }
            case 221: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(5);
                break;
            }
            case 222: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(6);
                break;
            }
            case 223: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(7);
                break;
            }
            case 224: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(8);
                break;
            }
            case 225: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(9);
                break;
            }
            case 226: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(10);
                break;
            }
            case 227: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(11);
                break;
            }
            case 228: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(12);
                break;
            }
            case 229: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(13);
                break;
            }
            case 230: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(14);
                break;
            }
            case 231: {
                dp = this.getDataFromPirit(1, 5L);
                res = dp.getLongValue(15);
                break;
            }
            case 232: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(6);
                break;
            }
            case 233: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(7);
                break;
            }
            case 234: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(8);
                break;
            }
            case 235: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(9);
                break;
            }
            case 236: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(10);
                break;
            }
            case 237: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(11);
                break;
            }
            case 238: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(12);
                break;
            }
            case 239: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(13);
                break;
            }
            case 240: {
                dp = this.getDataFromPirit(1, 3L);
                res = dp.getLongValue(14);
                break;
            }
            case 241: {
                dp = this.getDataFromPirit(2, 7L);
                res = dp.getLongValue(1);
                break;
            }
            case 242: {
                dp = this.getDataFromPirit(1, 8L);
                res = dp.getLongValue(3);
                break;
            }
            case 243: {
                dp = this.getDataFromPirit(1, 8L);
                res = dp.getLongValue(4);
            }
        }
        return res;
    }

    public synchronized long getNexDocNumberInShift() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(1, 2L);
        return dp.getLongValue(1);
    }

    public synchronized long getLastDocNumber() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(3, 2L);
        return dp.getLongValue(4);
    }

    public synchronized long getDocStatus() throws Exception {
        StringBuilder result = new StringBuilder();
        this.pc.SendPacket(0, "");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(0));
        long docStatus = dp.getLongValue(2);
        this.Log.debug((Object)("DocStatus is(" + docStatus + ")"));
        return docStatus;
    }

    public synchronized boolean isDocClosedInFN() throws Exception {
        long docStatus = this.getDocStatus();
        boolean docInFn = PiritService.getBit(docStatus, 7);
        this.Log.debug((Object)("DocClosedInFN is(" + docInFn + ")"));
        return docInFn;
    }

    public synchronized boolean isDocClosed() throws Exception {
        long docStatus = this.getDocStatus();
        boolean docIsClosed = docStatus <= 0L;
        this.Log.debug((Object)("docIsClosed is(" + docIsClosed + ")"));
        return docIsClosed;
    }

    public synchronized long getVatValue(int vatId) throws Exception {
        return (long)(Float.parseFloat(this.getStrValueTableSettings(41L, vatId)) * 100.0f);
    }

    public synchronized void setVatValue(int vatId, String vatValue) throws Exception {
        this.setStrValueTableSettings(41L, vatId, vatValue);
    }

    public synchronized String getVatName(int vatId) throws Exception {
        return new String(this.getStrValueTableSettings(40L, vatId).getBytes("ISO-8859-5"), "CP866");
    }

    public synchronized void setVatName(int vatId, String vatName) throws Exception {
        this.setStrValueTableSettings(40L, vatId, vatName);
    }

    public synchronized void printMoney(long total, String description) throws Exception {
        this.Log.debug((Object)("printMoney:" + total));
        DataPacket dp = new DataPacket();
        dp.putStringValue(description);
        dp.putDoubleValue((double)total / 100.0);
        this.pc.SendPacket(72, dp.getDataBuffer());
        this.readPacketPrint(72, dp.getDataBuffer());
    }

    public synchronized void addGoods(String item, long price, String quantity, int vatId, long unitPrice, String unitName, int discountType, long discountAmount) throws Exception {
        if (--vatId < 0) {
            vatId = 0;
        }
        if (vatId > 5) {
            vatId = 5;
        }
        DataPacket dp = new DataPacket();
        dp.putStringValue(item);
        dp.putStringValue(unitName);
        dp.putStringValue(quantity);
        dp.putDoubleValue((double)unitPrice / 100.0);
        dp.putLongValue(Long.valueOf(vatId));
        dp.putStringValue("");
        dp.putLongValue(0L);
        dp.putLongValue(Long.valueOf(discountType));
        dp.putStringValue(this.itemQuantityName);
        dp.putDoubleValue((double)discountAmount / 100.0);
        dp.putLongValue(this.attrMarkupType);
        dp.putLongValue(this.attrSubjectType);
        dp.putStringValue(this.countryCode);
        dp.putStringValue(this.customsDeclaration);
        this.pc.SendPacket(66, dp.getDataBuffer());
        this.readPacketPrint(66, dp.getDataBuffer());
        this.attrMarkupType = 4L;
        this.attrSubjectType = 1L;
        this.countryCode = "";
        this.customsDeclaration = "";
        this.itemQuantityName = "";
    }

    public synchronized void addDiscount(int adjustmentType, String name, long amount) throws Exception {
        DataPacket dp = new DataPacket();
        if (adjustmentType == 1) {
            dp.putLongValue(1L);
        } else {
            dp.putLongValue(0L);
        }
        dp.putStringValue(name);
        dp.putDoubleValue((double)amount / 100.0);
        this.pc.SendPacket(69, dp.getDataBuffer());
        this.readPacketPrint(69, dp.getDataBuffer());
        this.recepieData.setRounding(amount);
    }

    public synchronized void addMargin(int adjustmentType, String name, long amount) throws Exception {
        DataPacket dp = new DataPacket();
        if (adjustmentType == 2) {
            dp.putLongValue(1L);
        } else {
            dp.putLongValue(0L);
        }
        dp.putStringValue(name);
        dp.putDoubleValue((double)amount / 100.0);
        this.pc.SendPacket(70, dp.getDataBuffer());
        this.readPacketPrint(70, dp.getDataBuffer());
    }

    public synchronized void subtotal() throws Exception {
        this.pc.SendPacket(68, "");
        this.readPacketPrint(68, "");
        long receiptTotal = this.getReceiptTotal();
    }

    public synchronized void setTotalReceipt(int sum) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putDoubleValue((double)sum / 100.0);
        this.pc.SendPacket(100, dp.getDataBuffer());
    }

    private synchronized void printCalculationUnit() throws Exception {
        if (this.beginDocData != null && this.beginDocData.getReceiptType() > 256) {
            for (String unit : this.formatPaymentUnit()) {
                this.addRequesit(0L, unit);
            }
            this.addRequesit(0L, "-------------------------------------------");
        }
    }

    private synchronized List<String> formatDisountSubtotalUnit() {
        LinkedList<String> result = new LinkedList<String>();
        if (!this.recepieData.getDiscounts().isEmpty()) {
            for (Discount discount : this.recepieData.getDiscounts()) {
                String tmp = discount.getName() + ": " + discount.getAmount();
                result.add(tmp);
            }
            if (this.recepieData.getSubtotal() != null) {
                String tmp = (String)result.get(result.size() - 1);
                tmp = tmp + " \u041f\u043e\u0434\u0438\u0442\u043e\u0433: " + this.recepieData.getSubtotal().getSubtotal();
                this.recepieData.setSubtotal(null);
                result.set(result.size() - 1, tmp);
            }
            this.recepieData.clearDiscounts();
            return result;
        }
        if (this.recepieData.getSubtotal() != null) {
            String tmp = "\u041f\u043e\u0434\u0438\u0442\u043e\u0433: " + this.recepieData.getSubtotal().getSubtotal();
            result.add(tmp);
            this.recepieData.setSubtotal(null);
        }
        return result;
    }

    private synchronized List<String> formatPaymentUnit() {
        LinkedList<String> result = new LinkedList<String>();
        long sumRecepie = Long.valueOf(this.recepieData.getCashRequired());
        String roundStr = String.format("%-18s %7.2f %-8s %7.2f", "\u041e\u041a\u0420\u0423\u0413\u041b\u0415\u041d\u0418\u0415:", (double)this.recepieData.getRounding() / 100.0, "\u0418\u0422\u041e\u0413:", (double)sumRecepie / 100.0);
        result.add(roundStr);
        Collections.sort(this.recepieData.getPayments(), Payment.COMPARE_BY_ID);
        boolean printChashBack = false;
        if (!this.recepieData.getPayments().isEmpty()) {
            for (int i = 0; i < this.recepieData.getPayments().size(); ++i) {
                long change;
                long cashRequired;
                Payment payment = this.recepieData.getPayments().get(i);
                String paymentName = payment.getName();
                if ((paymentName = paymentName.trim()).length() > 19) {
                    paymentName = paymentName.substring(0, 19);
                }
                paymentName = paymentName + ":";
                StringBuilder line = new StringBuilder(20);
                line.append(paymentName);
                String tmp = String.format("%-18s %7.2f", line, (double)payment.getSum() / 100.0);
                if (i == 0) {
                    tmp = tmp + String.format("%-9s %7.2f", " \u041f\u0420\u0418\u041d\u042f\u0422\u041e:", (double)this.recepieData.getCashIn() / 100.0);
                } else if (i == 1) {
                    cashRequired = Long.valueOf(this.recepieData.getCashRequired());
                    change = this.recepieData.getCurrentPaymentSum() - cashRequired;
                    tmp = tmp + String.format("%-9s %7.2f", " \u0421\u0414\u0410\u0427\u0410:", (double)change / 100.0);
                    printChashBack = true;
                }
                if (!printChashBack && i != 0 || !printChashBack && this.recepieData.getPayments().size() == 1) {
                    cashRequired = Long.valueOf(this.recepieData.getCashRequired());
                    change = this.recepieData.getCurrentPaymentSum() - cashRequired;
                    String cash = tmp;
                    result.add(cash);
                    tmp = String.format("%-18s %7.2f", "\u042d\u041b\u0415\u041a\u0422\u0420\u041e\u041d\u041d\u042b\u041c\u0418:", 0.0);
                    tmp = tmp + String.format("%-9s %7.2f", " \u0421\u0414\u0410\u0427\u0410:", (double)change / 100.0);
                }
                result.add(tmp);
            }
            this.recepieData.clearPayments();
            return result;
        }
        return result;
    }

    public synchronized void putPayment(long sum, long paymentId) throws Exception {
        if (this.recepieData.getCashRequired() == null) {
            this.recepieData.setCashRequired(String.valueOf(this.getReceiptTotal()));
        }
        if (paymentId == 0L) {
            this.recepieData.setCashIn(this.recepieData.getCashIn() + sum);
        }
        this.recepieData.setCurrentPaymentSum(this.recepieData.getCurrentPaymentSum() + sum);
        String paymentName = this.getStrValueTableSettings(32L, paymentId);
        String utf8String = new String(paymentName.getBytes("ISO-8859-5"), "CP866");
        if (paymentId != 0L) {
            Payment payment = new Payment(sum, paymentId, utf8String);
            if (paymentId == 13L) {
                payment.setName("\u041f\u0420\u0415\u0414\u0412.\u041e\u041f\u041b.(\u0410\u0412\u0410\u041d\u0421)");
            }
            this.recepieData.addPayment(payment);
        }
        if (this.recepieData.getCurrentPaymentSum() >= Long.valueOf(this.recepieData.getCashRequired())) {
            long noCashSum = 0L;
            for (Payment payment : this.recepieData.getPayments()) {
                noCashSum += payment.getSum();
            }
            long cashResidue = Long.valueOf(this.recepieData.getCashRequired()) - noCashSum;
            this.recepieData.addPaymentFirst(new Payment(cashResidue, 0L, "\u041d\u0410\u041b\u0418\u0427\u041d\u042b\u041c\u0418"));
            this.printCalculationUnit();
        }
        DataPacket dp = new DataPacket();
        dp.putLongValue(paymentId);
        dp.putDoubleValue((double)sum / 100.0);
        dp.putStringValue("");
        dp.putStringValue(this.cashlessId);
        this.cashlessId = "";
        dp.putStringValue(this.cashlessInfo);
        this.cashlessInfo = "";
        dp.putStringValue(this.cashlessSign);
        this.cashlessSign = "";
        this.pc.SendPacket(71, dp.getDataBuffer());
        this.readPacketPrint(71, dp.getDataBuffer());
    }

    public synchronized void putText(long textAttribute, String text) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putStringValue(text);
        dp.putLongValue(textAttribute);
        this.pc.SendPacket(64, dp.getDataBuffer());
        this.readPacketPrint(64, dp.getDataBuffer());
    }

    public synchronized void putBarCode(long textPosition, long widthBarCode, long heightBarCode, long typeBarCode, String text) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(textPosition);
        dp.putLongValue(widthBarCode);
        dp.putLongValue(heightBarCode);
        dp.putLongValue(typeBarCode);
        dp.putStringValue(text);
        this.pc.SendPacket(65, dp.getDataBuffer());
        this.readPacketPrint(65, dp.getDataBuffer());
    }

    public synchronized void closeDoc() throws Exception {
        this.recepieData.clearDiscounts();
        this.recepieData.clearPayments();
        this.recepieData.setSubtotal(null);
        this.Log.info((Object)("Close Doc : BUYER_ADDRESS: " + this.buyerAddress));
        if (this.getDocStatus() != 0L) {
            DataPacket dataPacket = new DataPacket();
            long cutFlag = 0L;
            if (this.bCutReceipt) {
                cutFlag = 5L;
            }
            dataPacket.putLongValue(cutFlag);
            dataPacket.putStringValue(this.buyerAddress);
            dataPacket.putLongValue(this.differentFlags);
            if (this.currentFirmWare != 165L) {
                dataPacket.putStringValue(this.placeCalc);
                dataPacket.putStringValue(this.senderEmail);
                dataPacket.putStringValue(this.machineNumber);
                dataPacket.putStringValue(this.extraUserReqName);
                dataPacket.putStringValue(this.extraUserReqValue);
            }
            dataPacket.putStringValue(this.pokupatel);
            dataPacket.putStringValue(this.innPokupatelya);
            dataPacket.putStringValue("");
            dataPacket.putStringValue(this.buyerPassportData.getCitizenship());
            dataPacket.putStringValue(this.buyerPassportData.getPassportCode());
            dataPacket.putStringValue(this.buyerPassportData.getPassportData());
            dataPacket.putStringValue(this.buyerPassportData.getBuyerPhysicalAddress());
            this.pc.SendPacket(49, dataPacket.getDataBuffer());
            DataPacket dp = new DataPacket(this.pc.ReadPacket(49));
            try {
                this.Log.debug((Object)("Create CloseDocData: fiscalDocNumber: " + dp.getStringValue(0) + " operationCounter: " + dp.getStringValue(1) + " fiscalAttribute: " + dp.getStringValue(2)));
                this.closeDocData = new CloseDocData(dp.getStringValue(0), dp.getStringValue(1), dp.getStringValue(2));
            }
            catch (Exception e) {
                this.closeDocData = null;
                this.Log.error((Object)("Error get closeDocData : " + dp));
            }
            this.buyerAddress = "";
            this.differentFlags = null;
            this.placeCalc = "";
            this.senderEmail = "";
            this.machineNumber = "";
            this.extraUserReqName = "";
            this.extraUserReqValue = "";
            this.pokupatel = "";
            this.innPokupatelya = "";
            this.buyerPassportData.clearData();
        }
    }

    public synchronized void closeDocNoData() throws Exception {
        this.Log.info((Object)("Close Doc : BUYER_ADDRESS: " + this.buyerAddress));
        if (this.getDocStatus() != 0L) {
            DataPacket dpBuyerAddress = new DataPacket();
            if (!this.buyerAddress.equals("")) {
                long cutFlag = 0L;
                if (this.bCutReceipt) {
                    cutFlag = 5L;
                }
                dpBuyerAddress.putLongValue(cutFlag);
                dpBuyerAddress.putStringValue(this.buyerAddress);
                this.pc.SendPacket(49, dpBuyerAddress.getDataBuffer());
                this.pc.ReadPacket(49);
                this.buyerAddress = "";
            } else {
                long cutFlag = 0L;
                if (this.bCutReceipt) {
                    cutFlag = 5L;
                }
                dpBuyerAddress.putLongValue(cutFlag);
                this.pc.SendPacket(49, dpBuyerAddress.getDataBuffer());
                this.pc.ReadPacket(49);
                this.buyerAddress = "";
            }
        }
    }

    public synchronized void addRequesit(long textAttrib, String dataReq) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(0L);
        dp.putLongValue(textAttrib);
        dp.putStringValue(dataReq);
        dp.putLongValue(null);
        dp.putLongValue(null);
        dp.putLongValue(null);
        this.pc.SendPacket(73, dp.getDataBuffer());
        this.readPacketPrint(73, dp.getDataBuffer());
    }

    public synchronized void printCopyOfLastReceipt(BeginDocData beginDocData, CloseDocData closeDocData) throws Exception {
        if (beginDocData != null && closeDocData != null) {
            long receiptType = beginDocData.getReceiptType();
            long deptNumber = 1L;
            String operatorName = beginDocData.getOperatorName();
            long receiptNumber = beginDocData.getReceiptNumber();
            long cashNumber = 1L;
            Date dateReceipt = new Date();
            long numberFD = Long.valueOf(closeDocData.getDocNumberFN());
            long tax = 1L;
            DataPacket dp = new DataPacket();
            dp.putLongValue(receiptType);
            dp.putLongValue(deptNumber);
            dp.putStringValue(operatorName);
            dp.putLongValue(receiptNumber);
            dp.putLongValue(cashNumber);
            dp.putDateValue(dateReceipt);
            dp.putTimeValue(dateReceipt);
            dp.putLongValue(numberFD);
            dp.putLongValue(tax);
            this.pc.SendPacket(83, dp.getDataBuffer());
            this.readPacketPrint(83, dp.getDataBuffer());
        }
    }

    public synchronized void addReqForOFD(long reqCode, long textAttrib, String nameReq, String dataReq) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(reqCode);
        dp.putLongValue(textAttrib);
        dp.putStringValue(nameReq);
        dp.putStringValue(dataReq);
        this.pc.SendPacket(87, dp.getDataBuffer());
        this.pc.ReadPacket(87);
    }

    public synchronized void correctionReceipt(String nameOperator, Long sumCash, Long sumCashless, Long sumPrepayment, Long sumPostpay, Long sumCounterPayment, Long correctionType, Date docDate, String docNum, String docReason, Long sumNDS_20, Long sumNDS_10, Long sumNDS_0, Long sumWO_NDS, Long sumNDS_20_120, Long sumNDS_10_110, String addReq, String buyer, String buyerInn, String nameOfUsersAddReq, String valueOfUsersAddReq, Long timeout) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putStringValue(nameOperator);
        dp.putDoubleValue(this.makeDoubleFromLong(sumCash));
        dp.putDoubleValue(this.makeDoubleFromLong(sumCashless));
        dp.putDoubleValue(this.makeDoubleFromLong(sumPrepayment));
        dp.putDoubleValue(this.makeDoubleFromLong(sumPostpay));
        dp.putDoubleValue(this.makeDoubleFromLong(sumCounterPayment));
        dp.putLongValue(correctionType);
        dp.putDateValue(docDate);
        dp.putStringValue(docNum);
        dp.putStringValue(docReason);
        dp.putDoubleValue(this.makeDoubleFromLong(sumNDS_20));
        dp.putDoubleValue(this.makeDoubleFromLong(sumNDS_10));
        dp.putDoubleValue(this.makeDoubleFromLong(sumNDS_0));
        dp.putDoubleValue(this.makeDoubleFromLong(sumWO_NDS));
        dp.putDoubleValue(this.makeDoubleFromLong(sumNDS_20_120));
        dp.putDoubleValue(this.makeDoubleFromLong(sumNDS_10_110));
        dp.putStringValue(addReq);
        dp.putStringValue(buyer);
        dp.putStringValue(buyerInn);
        dp.putStringValue(nameOfUsersAddReq);
        dp.putStringValue(valueOfUsersAddReq);
        this.pc.SendPacket(88, dp.getDataBuffer());
        this.pc.ReadPacket(88, timeout);
    }

    public synchronized void printReportOnCurrentStatusOfCalc(String cashier) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putStringValue(cashier);
        dp.putStringValue(this.userAddress);
        dp.putStringValue(this.placeCalc);
        this.pc.SendPacket(89, dp.getDataBuffer());
        this.pc.ReadPacket(89);
        this.userAddress = "";
        this.placeCalc = "";
    }

    public synchronized Double makeDoubleFromLong(Long value) {
        return value == null ? null : Double.valueOf((double)value.longValue() / 100.0);
    }

    public synchronized String addExtraReqPosition(String ktn, String extraReq, String reserved, Long tagAgent, String innProv, String phoneProv, String nameProv, String addrOperTrans, String innOperTrans, String nameOperTrans, String phoneOperTrans, String operationPayAgent, String phonePayAgent, String phoneOperPayReception, Long foivId, String foundationDocumentDate, String foundationDocumentNumber, String industryReqValue) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putStringValue(ktn);
        dp.putStringValue(extraReq);
        dp.putStringValue(reserved);
        dp.putLongValue(tagAgent);
        dp.putStringValue(innProv);
        dp.putStringValue(phoneProv);
        dp.putStringValue(nameProv);
        dp.putStringValue(addrOperTrans);
        dp.putStringValue(innOperTrans);
        dp.putStringValue(nameOperTrans);
        dp.putStringValue(phoneOperTrans);
        dp.putStringValue(operationPayAgent);
        dp.putStringValue(phonePayAgent);
        dp.putStringValue(phoneOperPayReception);
        dp.putLongValue(foivId);
        dp.putStringValue(foundationDocumentDate);
        dp.putStringValue(foundationDocumentNumber);
        dp.putStringValue(industryReqValue);
        this.pc.SendPacket(36, dp.getDataBuffer());
        return this.readPacketPrint(36, dp.getDataBuffer());
    }

    public synchronized int[] markCodeBaseRequest(long requestNumber, int resultDataCount) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(requestNumber);
        this.pc.SendPacket(121, dp.getDataBuffer());
        DataPacket resultDp = new DataPacket(this.pc.ReadPacket(121));
        int[] result = new int[resultDataCount];
        for (int i = 0; i < resultDataCount; ++i) {
            try {
                result[i] = (int)resultDp.getLongValue(i);
                continue;
            }
            catch (NumberFormatException nfe) {
                this.Log.debug((Object)("validation result " + i + " no data"));
            }
        }
        return result;
    }

    public synchronized int[] markCodeValidation(String markCode, String quantity, long itemState, long quantityMode, long workMode) throws Exception {
        Long requestNumber = 1L;
        String defaultQuantity = "1";
        DataPacket dp = new DataPacket();
        dp.putLongValue(requestNumber);
        dp.putStringValue(markCode);
        dp.putLongValue(0L);
        dp.putLongValue(itemState);
        dp.putStringValue(StringUtils.isBlank((CharSequence)quantity) ? "1" : quantity);
        dp.putLongValue(quantityMode);
        dp.putLongValue(workMode);
        this.pc.SendPacket(121, dp.getDataBuffer());
        DataPacket resultDp = new DataPacket(this.pc.ReadPacket(121, this.getReadTimeOut() + this.getOismServerTimeout()));
        int resultDataCount = 5;
        int[] result = new int[5];
        for (int i = 0; i < 5; ++i) {
            try {
                result[i] = (int)resultDp.getLongValue(i + 1);
                continue;
            }
            catch (NumberFormatException nfe) {
                this.Log.debug((Object)("validation result " + i + " no data"));
            }
        }
        return result;
    }

    public synchronized long confirmMarkCode(long confirmMode) throws Exception {
        Long requestNumber = 2L;
        DataPacket dp = new DataPacket();
        dp.putLongValue(requestNumber);
        dp.putLongValue(confirmMode);
        this.pc.SendPacket(121, dp.getDataBuffer());
        DataPacket resultDp = new DataPacket(this.pc.ReadPacket(121));
        return resultDp.getLongValue(1);
    }

    public synchronized void addMarkCode(String markCode, long itemState, long quantityMode, long validationResult) throws Exception {
        Long requestNumber = 15L;
        DataPacket dp = new DataPacket();
        dp.putLongValue(requestNumber);
        dp.putStringValue(markCode);
        dp.putLongValue(itemState);
        dp.putLongValue(0L);
        dp.putLongValue(validationResult);
        dp.putLongValue(quantityMode);
        this.pc.SendPacket(121, dp.getDataBuffer());
        this.pc.ReadPacket(121);
    }

    public synchronized void printFiscalReportByDate(String date1, String date2) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyyyyhhmm");
        DataPacket dp = new DataPacket();
        dp.putLongValue(1L);
        dp.putDateValue(df.parse(date1));
        dp.putDateValue(df.parse(date2));
        dp.putStringValue(this.config.getPassword());
        this.pc.SendPacket(98, dp.getDataBuffer());
        this.pc.ReadPacket(98);
    }

    public synchronized void printFiscalReportByShiftId(long startShiftId, long endShiftId) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(1L);
        dp.putLongValue(startShiftId);
        dp.putLongValue(endShiftId);
        dp.putStringValue(this.config.getPassword());
        this.pc.SendPacket(97, dp.getDataBuffer());
        this.pc.ReadPacket(97);
    }

    public synchronized void printCopyZReport() throws Exception {
        this.pc.SendPacket(161, "");
        this.pc.ReadPacket(161);
    }

    public synchronized void printXReport(String cashier) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putStringValue(cashier);
        this.startWork();
        this.pc.SendPacket(32, dp.getDataBuffer());
        this.pc.ReadPacket(32);
    }

    public synchronized void printZReport(String cashier) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putStringValue(cashier);
        dp.putLongValue(null);
        dp.putStringValue(this.userAddress);
        dp.putStringValue(this.placeCalc);
        this.startWork();
        this.pc.SendPacket(33, dp.getDataBuffer());
        this.pc.ReadPacket(33);
        this.userAddress = "";
        this.placeCalc = "";
    }

    public synchronized void openShift(String cashier, long opkServerTimeout, long timeZoneNumber) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putStringValue(cashier);
        dp.putStringValue(this.userAddress);
        dp.putStringValue(this.placeCalc);
        if (timeZoneNumber > 0L) {
            dp.putLongValue(timeZoneNumber);
        }
        this.pc.SendPacket(35, dp.getDataBuffer());
        this.pc.ReadPacket(35, opkServerTimeout);
        this.userAddress = "";
        this.placeCalc = "";
    }

    public synchronized void openMoneyDrawer() throws Exception {
        this.pc.SendPacket(128, "");
        this.pc.ReadPacket(128);
    }

    public synchronized Boolean isMoneyDrawerOpen() throws Exception {
        this.pc.SendPacket(129, "");
        DataPacket dp = new DataPacket(this.pc.ReadPacket(129));
        if (dp.getLongValue(0) == 1L) {
            return true;
        }
        return false;
    }

    public synchronized String getFiscalOfdReceiptFromRepo(long receipNumbder) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(12L);
        dp.putLongValue(receipNumbder);
        System.out.println("dp " + dp.toString());
        this.pc.SendPacket(120, dp.getDataBuffer());
        String result = this.pc.ReadPacket(120);
        return result;
    }

    public synchronized String getRegNumberFN() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(120, 1L);
        String lRes = dp.getStringValue(1);
        return lRes;
    }

    public synchronized long getOFDStatusAmountUnsentDocs() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(120, 7L);
        long lRes = dp.getLongValue(2);
        return lRes;
    }

    public synchronized Date getOFDStatusDateFirstUnsentDocs() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(120, 7L);
        int countValue = dp.getCountValue();
        Date lRes = countValue == 6 ? dp.getDateTimeValue(4, 5) : dp.getDateValue(4);
        return lRes;
    }

    public synchronized Date getDateTimeReg() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(120, 4L);
        Date lRes = dp.getDateTimeValue(1, 2);
        return lRes;
    }

    public synchronized long getNumberDocOfLastReregistration() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(120, 5L);
        long lRes = dp.getLongValue(1);
        return lRes;
    }

    public synchronized long getLastFiscalNumberDoc() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(120, 3L);
        long lRes = dp.getLongValue(1);
        return lRes;
    }

    public synchronized String getFNVersion() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(120, 14L);
        return dp.getStringValue(1);
    }

    public synchronized long getFFDVersion() throws Exception {
        DataPacket dp = new DataPacket();
        dp = this.getDataFromPirit(120, 14L);
        long lRes = dp.getLongValue(3);
        return lRes;
    }

    public synchronized Vector<PiritFNTicket> getSignedFiscalDocsFromMemory(int[] arg1) throws Exception {
        Vector<PiritFNTicket> tickets = this.getFiscalDocsFromMemory(arg1);
        Vector<PiritFNTicket> resultTickets = new Vector<PiritFNTicket>();
        for (PiritFNTicket ticket : tickets) {
            if (!ticket.isSigned()) continue;
            resultTickets.add(ticket);
        }
        return resultTickets;
    }

    public synchronized Vector<PiritFNTicket> getRangeFiscalDocsFromMemory(int[] arg1) throws Exception {
        int[] range;
        int lastNumber = (int)this.getLastFiscalNumberDoc();
        if (arg1[0] >= lastNumber) {
            range = new int[]{lastNumber};
        } else {
            range = new int[lastNumber - arg1[0] + 1];
            for (int i = 0; i < range.length; ++i) {
                range[i] = arg1[0] + i;
            }
        }
        Vector<PiritFNTicket> tickets = this.getFiscalDocsFromMemory(range);
        return tickets;
    }

    public synchronized Vector<PiritFNTicket> getSortCountFiscalDocsFromMemory(int[] arg1) throws Exception {
        int[] range;
        Vector<PiritFNTicket> tickets = new Vector();
        int requestAmount = arg1[1];
        int startRecepieNumber = arg1[0];
        int lastNumber = (int)this.getLastFiscalNumberDoc();
        if (startRecepieNumber >= lastNumber) {
            range = new int[]{lastNumber};
        } else {
            int avialableAmount = lastNumber - startRecepieNumber;
            if (avialableAmount < requestAmount) {
                requestAmount = avialableAmount + 1;
            }
            range = new int[requestAmount];
            for (int i = 0; i < range.length; ++i) {
                range[i] = startRecepieNumber + i;
            }
        }
        tickets = this.getFiscalDocsFromMemory(range);
        return tickets;
    }

    public synchronized Vector<PiritFNTicket> getFiscalDocsFromMemory(int[] arg1) throws Exception {
        Vector<PiritFNTicket> tickets = new Vector<PiritFNTicket>();
        for (int docNumber : arg1) {
            String docHEX;
            block5: {
                DataPacket dp = new DataPacket();
                docHEX = null;
                dp.putLongValue(11L);
                dp.putLongValue(Long.valueOf(docNumber));
                dp.putLongValue(null);
                this.pc.SendPacket(120, dp.getDataBuffer());
                try {
                    docHEX = this.pc.ReadPacket(120);
                }
                catch (JposException e) {
                    if (e.getErrorCodeExtended() != 72) break block5;
                    docHEX = null;
                }
            }
            if (docHEX == null) continue;
            try {
                tickets.add(new PiritFNTicket(docHEX, docNumber));
            }
            catch (Exception e) {
                tickets.add(new PiritFNTicket(docNumber));
            }
        }
        return tickets;
    }

    public synchronized void setSenderAdress(String senderAddres) throws Exception {
        this.Log.debug((Object)("setSenderAdress is(" + senderAddres + ")"));
        this.setStrValueTableSettings(82L, 0L, senderAddres);
    }

    public synchronized void setShopCode(String ShopCode) throws Exception {
        this.Log.debug((Object)("setShopCode is(" + ShopCode + ")"));
        this.setStrValueTableSettings(52L, 3L, ShopCode);
    }

    public synchronized String getStrValueTableSettings(long number, long index) throws Exception {
        String result = "";
        DataPacket dp = new DataPacket();
        dp.putLongValue(number);
        dp.putLongValue(index);
        this.pc.SendPacket(17, dp.getDataBuffer());
        dp = new DataPacket(this.pc.ReadPacket(17));
        if (dp.getCountValue() > 0) {
            result = dp.getStringValue(0);
        }
        return result;
    }

    public synchronized void printSeparateLine(int startPos, int endPos, int hight) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(Long.valueOf(startPos));
        dp.putLongValue(Long.valueOf(endPos));
        dp.putLongValue(Long.valueOf(hight));
        this.pc.SendPacket(101, dp.getDataBuffer());
        this.pc.ReadPacket(101);
    }

    public synchronized void printTextQRcode(long textAttr, long whidthQR, long textPos, long qrPos, String string1, String string2, String code) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(textAttr);
        dp.putLongValue(whidthQR);
        dp.putLongValue(textPos);
        dp.putLongValue(qrPos);
        dp.putStringValue(string1);
        dp.putStringValue(string2);
        dp.putStringValue(code);
        this.pc.SendPacket(102, dp.getDataBuffer());
        this.pc.ReadPacket(102);
    }

    public String getOFDName() throws Exception {
        return new String(this.getStrValueTableSettings(81L, 0L).getBytes("ISO-8859-1"), "CP866");
    }

    public String getOFDserverAddress() throws Exception {
        return this.getStrValueTableSettings(77L, 0L);
    }

    public String getOFDserverPort() throws Exception {
        return this.getStrValueTableSettings(78L, 0L);
    }

    public String getOFDTimeout() throws Exception {
        return this.getStrValueTableSettings(80L, 0L);
    }

    public synchronized void setStrValueTableSettings(long number, long index, String value) throws Exception {
        DataPacket dp = new DataPacket();
        dp.putLongValue(number);
        dp.putLongValue(index);
        dp.putStringValue(value);
        this.pc.SendPacket(18, dp.getDataBuffer());
        this.pc.ReadPacket(18);
    }

    private synchronized String readPacketPrint(int cmd, String cmdDataBuffer) throws Exception {
        if (!this.bEnablePacketPrint) {
            return this.pc.ReadPacket(cmd);
        }
        int packetPrefixSize = 11;
        this.currentBufferSize.addAndGet(cmdDataBuffer.length() + 11);
        if (this.currentBufferSize.get() > 2048) {
            this.currentBufferSize.set(0);
            this.isConnect();
        }
        return null;
    }

    public static boolean getBit(long number, int bitNum) {
        return (number & (long)(1 << bitNum)) > 0L;
    }

    public static long setBit(long number, int bitNum) {
        return number |= (long)(1 << bitNum);
    }

    public static long unsetBit(long number, int bitNum) {
        return number &= (long)(~(1 << bitNum));
    }

    public static int getLowHalfByte(long number) {
        byte b = (byte)number;
        return b & 0xF;
    }

    public static int getHighHalfByte(long number) {
        byte b = (byte)number;
        return (b & 0xF0) >> 4;
    }

    public synchronized String getPhysicalDescription() {
        return physicalDescription;
    }

    public synchronized String getPhysicalName() {
        return physicalName;
    }

    public synchronized String getServiceDescription() {
        return getServiceDescription;
    }

    public synchronized List<Integer> getAllSTLV() {
        return this.allSTLV;
    }
}

