/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector;

public class PiritFNTicket {
    private final int docNumber;
    private final byte[] hexData;
    private boolean signed = false;
    private String dataString = "";
    private String dateOfDoc = "";
    private String dateOfDocCool = "";
    private String ticketNumber = "";
    private String valueFPD = "";
    private int startIndex = 0;

    public PiritFNTicket(String data, int docNumber) {
        this.signed = data.startsWith("1");
        this.dataString = data.substring(2);
        this.hexData = this.dataString.getBytes();
        this.docNumber = docNumber;
        this.makeDataFromHexFn();
        this.makeTiketNumber();
        this.makeFPD();
    }

    public PiritFNTicket(int docNumber) {
        this.signed = false;
        this.dataString = "";
        this.hexData = new byte[]{0};
        this.docNumber = docNumber;
    }

    public int getDocNumber() {
        return this.docNumber;
    }

    public byte[] getHexData() {
        return this.hexData;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public String getDateOfDocCool() {
        return this.dateOfDocCool;
    }

    public String getDateOfDoc() {
        return this.dateOfDoc;
    }

    public String getTicketNumber() {
        return this.ticketNumber;
    }

    public String getValueFPD() {
        return this.valueFPD;
    }

    private void makeDataFromHexFn() {
        String year = PiritFNTicket.hexToDecimal(this.dataString.substring(this.startIndex, this.startIndex + 2));
        String month = PiritFNTicket.hexToDecimal(this.dataString.substring(this.startIndex + 2, this.startIndex + 4));
        String day = PiritFNTicket.hexToDecimal(this.dataString.substring(this.startIndex + 4, this.startIndex + 6));
        String hours = PiritFNTicket.hexToDecimal(this.dataString.substring(this.startIndex + 6, this.startIndex + 8));
        String mins = PiritFNTicket.hexToDecimal(this.dataString.substring(this.startIndex + 8, this.startIndex + 10));
        this.dateOfDoc = day + month + "20" + year + hours + mins;
        this.dateOfDocCool = day + "." + month + "." + year + " " + hours + ":" + mins;
    }

    private void makeTiketNumber() {
        String partNumber = "";
        StringBuilder number = new StringBuilder();
        for (int i = 10; i < 18; i += 2) {
            partNumber = this.dataString.substring(this.startIndex + i, this.startIndex + i + 2);
            partNumber = partNumber + number.toString();
            number.delete(0, 7);
            number.append(partNumber);
        }
        this.ticketNumber = PiritFNTicket.hexToDecimal(number.toString());
    }

    private void makeFPD() {
        String partNumber = "";
        StringBuilder number = new StringBuilder();
        for (int i = 18; i < 26; i += 2) {
            partNumber = this.dataString.substring(this.startIndex + i, this.startIndex + i + 2);
            partNumber = partNumber + number.toString();
            number.delete(0, 8);
            number.append(partNumber);
        }
        this.valueFPD = PiritFNTicket.hexToDecimalFPD(number.toString());
    }

    private static String hexToDecimal(String hex) {
        String digits = "0123456789ABCDEF";
        String result = "";
        hex = hex.toUpperCase();
        long val = 0L;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            int d = digits.indexOf(c);
            val = 16L * val + (long)d;
        }
        result = val < 10L ? "0" + String.valueOf(val) : String.valueOf(val);
        return result;
    }

    private static String hexToDecimalFPD(String hex) {
        String digits = "0123456789ABCDEF";
        String result = "";
        hex = hex.toUpperCase();
        long val = 0L;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            int d = digits.indexOf(c);
            val = 16L * val + (long)d;
        }
        result = String.valueOf(val);
        if (result.length() < 10) {
            result = "0" + result;
        }
        return result;
    }
}

