/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jpos.JposException;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.EventCallbacks;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import ru.crystals.pos.Version;
import ru.crystals.pos.fiscalprinter.jpos.pirit.PiritSvc112;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.DriverUtil;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.PiritErrorMsg;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.PortConnector;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataExchanger.DataReader;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataExchanger.DataWriter;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataPort.DataPort;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataPort.IpDataPort;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.dataPort.SerialDataPort;
import ru.crystals.pos.fiscalprinter.jpos.pirit.utils.DocFromFN;
import ru.crystals.pos.fiscalprinter.jpos.pirit.utils.Pair;

public class PiritConnector {
    private Logger Log = null;
    private final byte ENQ = (byte)5;
    private final byte ACK = (byte)6;
    private final String SOH = "\u0001";
    private final String STX = "\u0002";
    private final String ETX = "\u0003";
    private final int THREAD_SLEEP_TIME = 2;
    private final String PASSWORD = "PIRI";
    private static long READ_TIME_OUT = 4000L;
    private static long DEF_READ_TIME_OUT = 4000L;
    private int packetId;
    private int sendId;
    private String portName = "";
    private DataPort dataPort = null;
    private static final int MIN_PACKET_ID = 32;
    private static final int MAX_PACKET_ID = 240;
    private int test_max_packet_id = 121;
    private boolean testMode = false;
    private InputStream is = null;
    private BufferedInputStream bis = null;
    private InputStreamReader isr = null;
    private OutputStream os = null;
    private BufferedOutputStream bos = null;
    private OutputStreamWriter osw = null;
    private String encoding = "cp866";
    private PropertyChangeSupport exeptionResolver = null;
    private boolean paperOut = false;
    private boolean connectionError = false;
    private final String loggerName;
    private PortConnector portConnector = null;
    private Lock lock = new ReentrantLock();
    private DataWriter dataWriter = null;
    private DataReader dataReader = null;
    private volatile boolean packetPrint = false;
    private static final long DATA_TRANSFER_PAUSE = 20L;
    private volatile boolean stopReadProcess = false;

    public PiritConnector(String loggerName, FileAppender fa, long timeOut) {
        READ_TIME_OUT = timeOut;
        this.loggerName = loggerName;
        this.Log = Logger.getLogger((String)(loggerName + " " + this.getClass().getName()));
        this.Log.setLevel(Level.INFO);
        this.Log.addAppender((Appender)fa);
        this.packetId = 32;
        this.exeptionResolver = new PropertyChangeSupport(this);
    }

    public void addListener(PropertyChangeListener listener) {
        this.exeptionResolver.addPropertyChangeListener(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.exeptionResolver.removePropertyChangeListener(listener);
    }

    public static long getReadTimeOut() {
        return READ_TIME_OUT;
    }

    public void open(PortConnector portConnector) throws Exception {
        this.portConnector = portConnector;
        if (!this.isTcpPort(portConnector.getPortName())) {
            this.Log.info((Object)"Start COM port work mode");
            this.dataPort = new SerialDataPort();
            this.dataPort.open(portConnector.getPortName(), portConnector.getBaudRate(), portConnector.getDataBits(), portConnector.getStopBits(), portConnector.getParity(), portConnector.getParity(), portConnector.getUseCTS());
        } else {
            this.Log.info((Object)"Start TCP port work mode");
            this.dataPort = new IpDataPort();
            this.dataPort.open(portConnector.getPortName());
            this.Log.info((Object)"TCP started ");
        }
        this.dataWriter = new DataWriter(this.dataPort, 20L);
        this.dataReader = new DataReader(this.dataPort, 20L);
    }

    public void close() throws Exception {
        try {
            if (this.dataWriter != null) {
                this.dataWriter.interrupt();
            }
            if (this.dataReader != null) {
                this.dataReader.interrupt();
            }
            if (this.dataPort != null) {
                this.dataPort.closePort();
            }
            this.stopReadProcess = true;
        }
        catch (Exception localException) {
            throw new JposException(111, "Error close data port - " + localException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(byte data) throws Exception {
        DataPort dataPort = this.dataPort;
        synchronized (dataPort) {
            this.dataWriter.writeData(data);
        }
        this.logDebugCommand(data);
    }

    public synchronized void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void logDebugResponce(String text) {
        this.Log.info((Object)("read <-- " + this.convertDebugLog(text)));
    }

    public void logDebugResponce(byte[] responce) {
        this.Log.info((Object)("read <-- " + this.getForLogBytesAsString(responce)));
    }

    public void logDebugResponce(int responce) {
        this.Log.info((Object)("read <-- " + String.format("0x%X ", responce)));
    }

    private synchronized int packetIdIncrementAndGet() {
        if (this.testMode) {
            return this.testPacketIdIncrementAndGet();
        }
        ++this.packetId;
        if (this.packetId > 240) {
            this.packetId = 32;
        }
        return this.packetId;
    }

    private synchronized int testPacketIdIncrementAndGet() {
        ++this.packetId;
        if (this.packetId > this.test_max_packet_id) {
            this.packetId = 32;
        }
        return this.packetId;
    }

    public synchronized int SendPacket(int cmd, String data) throws Exception {
        StringBuilder packet = new StringBuilder();
        try {
            int expectedPacketId;
            this.sendId = expectedPacketId = this.packetIdIncrementAndGet();
            this.lock.lock();
            packet.append("\u0002");
            packet.append("PIRI");
            packet.append((char)expectedPacketId);
            packet.append(String.format("%02X", cmd));
            packet.append(data);
            packet.append("\u0003");
            packet.append(String.format("%02X", this.calculateCrc(packet.toString())));
            if (this.connectionError) {
                this.dataPort.closePort();
                Thread.sleep(500L);
                this.dataPort.openPort();
                this.connectionError = false;
            }
            byte[] byteData = packet.toString().getBytes(this.encoding);
            byteData[5] = (byte)this.sendId;
            this.dataWriter.writeData(byteData);
            long startTime = System.currentTimeMillis();
            while (!this.dataWriter.isIterationSuccess()) {
                if (System.currentTimeMillis() - startTime <= READ_TIME_OUT) continue;
                if (!this.connectionError) {
                    this.connectionError = true;
                }
                this.unlock();
                throw new JposException(111, "Send data timeout error");
            }
            this.logDebugCommand(packet.toString());
            int n = expectedPacketId;
            return n;
        }
        catch (IOException e) {
            this.unlock();
            this.Log.error((Object)"", (Throwable)e);
            throw new JposException(111, "Error send data packet");
        }
        finally {
            if (this.packetPrint) {
                this.unlock();
            }
        }
    }

    private int calculateCrc(String string) throws UnsupportedEncodingException {
        int crc = 0;
        byte[] arr = string.getBytes(this.getEncoding());
        arr[5] = (byte)this.sendId;
        for (int i = 1; i < arr.length; ++i) {
            crc = (crc ^ arr[i]) & 0xFF;
        }
        return crc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setPacketPrint(boolean packetPrint) {
        this.packetPrint = packetPrint;
    }

    public void logDebugCommand(String text) {
        this.Log.info((Object)("send --> " + this.convertDebugLog(text)));
    }

    public void logDebugCommand(byte[] command) {
        this.Log.info((Object)("send --> " + this.getForLogBytesAsString(command)));
    }

    public void logDebugCommand(byte command) {
        this.Log.info((Object)("send --> " + String.format("0x%X ", command)));
    }

    public void logDebugCommand(int command) {
        this.Log.info((Object)("send --> " + String.format("0x%X ", command)));
    }

    private String getForLogBytesAsString(byte[] command) {
        StringBuilder result = new StringBuilder();
        for (byte i : command) {
            result.append(String.format("0x%X ", i));
        }
        return result.toString();
    }

    private String convertDebugLog(String text) {
        if (this.Log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            char[] cArray = text.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                if (c.charValue() > '\u00ff' || c.toString().matches("[\\p{Print}]")) {
                    sb.append(c);
                    continue;
                }
                sb.append(String.format("{%02d}", c.charValue()));
            }
            return sb.toString();
        }
        return text;
    }

    private synchronized String readPacketData(int cmd, long readTimeOut) throws Exception {
        StringBuilder packet = new StringBuilder();
        long startTime = System.currentTimeMillis();
        boolean timeOut = false;
        int repeatCount = 2;
        int c = 0;
        String hex = "";
        while (true) {
            if (!this.stopReadProcess && !this.dataReader.isEmpty()) {
                hex = this.dataReader.getNextDataPacket();
                c = Integer.valueOf(DriverUtil.hexToDecimal(hex));
                if (c == 6 && cmd == 21) {
                    return "";
                }
                if (c == 6) {
                    this.Log.trace((Object)("<-- pong 0x" + c));
                    if (repeatCount-- <= 0) continue;
                    timeOut = false;
                    continue;
                }
                packet.append((char)c);
                if (packet.length() == 1 && c == "\u0002".charAt(0)) {
                    timeOut = true;
                }
                if (packet.indexOf("\u0002") == -1) {
                    packet = new StringBuilder();
                    continue;
                }
                if (packet.length() < 9 || packet.indexOf("\u0003") != packet.length() - 3) continue;
                break;
            }
            if (System.currentTimeMillis() - startTime > readTimeOut | this.stopReadProcess) {
                if (timeOut | this.stopReadProcess) {
                    throw new Exception("TimeOut read of data");
                }
                this.logDebugResponce("endTime - " + packet.toString());
                this.sendData((byte)5);
                timeOut = true;
                continue;
            }
            Thread.sleep(2L);
        }
        return packet.toString();
    }

    public synchronized String ReadPacket(int cmd) throws Exception {
        READ_TIME_OUT = cmd != 33 && cmd != 161 && cmd != 35 && cmd != 48 ? DEF_READ_TIME_OUT : 30000L;
        return this.ReadPacket(cmd, READ_TIME_OUT, this.packetId);
    }

    public synchronized String ReadPacket(int cmd, long timeOut) throws Exception {
        return this.ReadPacket(cmd, timeOut, this.packetId);
    }

    private StringBuilder getNextPacketThread(int cmd, long readTimeOut) throws JposException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(this.readPacketData(cmd, readTimeOut));
        }
        catch (Exception e) {
            throw new JposException(111);
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String ReadPacket(int cmd, long readTimeOut, int expectedPacketId) throws Exception {
        StringBuilder packet = new StringBuilder();
        char receivedId = '\u0000';
        int codeCmd = 0;
        int readCRC = 0;
        int calcCRC = 0;
        try {
            int errorCode;
            try {
                packet = this.getNextPacketThread(cmd, readTimeOut);
            }
            catch (Exception e) {
                this.Log.warn((Object)e);
                throw new JposException(111, "Error read of data");
            }
            finally {
                this.logDebugResponce(packet.toString());
            }
            if (packet.toString().equals("")) {
                this.close();
                this.open(this.portConnector);
                throw new JposException(111, "Error read of data");
            }
            try {
                receivedId = packet.charAt(1);
                errorCode = Integer.parseInt(packet.substring(4, 6), 16);
                if (expectedPacketId != receivedId) {
                    if (errorCode != 0) {
                        this.unlock();
                        this.Log.error((Object)("Error packet Id: errorCode= " + errorCode + " sendId=" + this.sendId + " receivedId=" + receivedId));
                        throw new JposException(111, errorCode, PiritErrorMsg.getErrorMessage(errorCode));
                    }
                    while (expectedPacketId != receivedId) {
                        this.unlock();
                        this.Log.error((Object)("Error packet Id: expectedPacketId=" + expectedPacketId + " receivedId=" + receivedId));
                        packet = this.getNextPacketThread(cmd, readTimeOut);
                        receivedId = packet.charAt(1);
                        errorCode = Integer.parseInt(packet.substring(4, 6), 16);
                    }
                }
                codeCmd = Integer.parseInt(packet.substring(2, 4), 16);
                readCRC = Integer.parseInt(packet.substring(packet.length() - 2, packet.length()), 16);
            }
            catch (NumberFormatException nfe) {
                this.unlock();
                this.Log.error((Object)"Error data packet format", (Throwable)nfe);
                throw new JposException(111, "Error read of data");
            }
            String arr = packet.toString();
            for (int i = 1; i < arr.length() - 2; ++i) {
                calcCRC = (calcCRC ^ arr.charAt(i)) & 0xFF;
            }
            if (errorCode == 4) {
                this.unlock();
                throw new JposException(111, "Error buffer overflow");
            }
            if (codeCmd != cmd) {
                this.Log.error((Object)("Error code Cmd: txCodeCmd=" + cmd + " rxCodeCmd=" + codeCmd));
                this.unlock();
                throw new JposException(111, "Error code Cmd: txCodeCmd=" + cmd + " rxCodeCmd=" + codeCmd);
            }
            if (calcCRC != readCRC) {
                this.Log.error((Object)("Error CRC: readCRC=" + readCRC + " calcCRC=" + calcCRC));
                this.unlock();
                throw new JposException(111, "Error CRC: readCRC=" + readCRC + " calcCRC=" + calcCRC);
            }
            if (errorCode != 0) {
                this.Log.error((Object)("Error code=" + errorCode + ", error message=" + PiritErrorMsg.getErrorMessage(errorCode)));
                this.unlock();
                throw new JposException(111, errorCode, PiritErrorMsg.getErrorMessage(errorCode));
            }
            try {
                this.unlock();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = packet.substring(6, packet.length() - 3);
            return string;
        }
        finally {
            try {
                this.unlock();
            }
            catch (Exception exception) {}
        }
    }

    private boolean isTcpPort(String portName) {
        return this.validIP(portName);
    }

    private void unlock() {
        try {
            this.lock.unlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean validIP(String ip) {
        try {
            if (ip == null || ip.isEmpty()) {
                return false;
            }
            String ipForCheck = ip.replace(":", ".");
            String[] parts = ipForCheck.split("\\.");
            if (parts.length != 5) {
                return false;
            }
            for (int i = 0; i < parts.length - 1; ++i) {
                int j = Integer.parseInt(parts[i]);
                if (j >= 0 && j <= 255) continue;
                return false;
            }
            Integer.parseInt(parts[4]);
            return !ip.endsWith(".");
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static long getDefReadTimeOut() {
        return DEF_READ_TIME_OUT;
    }

    public static void setDefReadTimeOut(long defReadTimeOut) {
        DEF_READ_TIME_OUT = defReadTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("start " + Version.getVersion());
        PiritSvc112 piritSvc112 = new PiritSvc112();
        System.out.println(piritSvc112.getDeviceServiceVersion());
        EventCallbacks callBacks = piritSvc112.createPiritCallBacks();
        StatusUpdateListener listener = new StatusUpdateListener(){

            public void statusUpdateOccurred(StatusUpdateEvent statusUpdateEvent) {
                if (statusUpdateEvent.getStatus() == 2001) {
                    System.err.println("listener - ! - FR online");
                }
                if (statusUpdateEvent.getStatus() == 2003) {
                    System.err.println("listener - ! - FR offline");
                }
                if (statusUpdateEvent.getStatus() == 24) {
                    System.err.println("listener - ! - NO PAPER");
                }
                if (statusUpdateEvent.getStatus() == 26) {
                    System.err.println("listener - ! - PAPER OK");
                }
                if (statusUpdateEvent.getStatus() == 11) {
                    System.err.println("listener - ! - COVER OPEN");
                }
                if (statusUpdateEvent.getStatus() == 12) {
                    System.err.println("listener - ! - COVER OK");
                }
            }
        };
        piritSvc112.addStatusUpdateListener(listener);
        try {
            piritSvc112.open("PIRIT-2F", null);
            piritSvc112.claim(3000);
            piritSvc112.setDeviceEnabled(true);
            String[] arg5 = new String[2];
            piritSvc112.getData(9, null, arg5);
        }
        catch (Exception arg5) {
            // empty catch block
        }
        ArrayList inputParams = new ArrayList();
        Collections.addAll(inputParams, args);
        Long docNumber = null;
        String documentFileName = "";
        if (inputParams.size() > 0) {
            if (((String)inputParams.get(0)).length() > 0) {
                docNumber = Long.parseLong((String)inputParams.get(0));
            }
            if (inputParams.size() > 1) {
                documentFileName = (String)inputParams.get(1);
            }
        } else {
            System.out.println("No one parameter was found. Usage: number filename");
            piritSvc112.close();
            return;
        }
        if (documentFileName.isEmpty()) {
            documentFileName = "doc" + docNumber + ".txt";
        }
        DocFromFN docFromFN = piritSvc112.getDocFromFN(docNumber);
        List<String> list = piritSvc112.getRawDocInTLV();
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(documentFileName));
            String name = "Document #" + docNumber + " in hex:\n";
            out.write(name.getBytes());
            for (String line : list) {
                out.write(line.getBytes());
                out.write("\n".getBytes());
            }
            out.write("\n-------------------------------\n".getBytes());
            name = "Document #" + docNumber + " in readable style:\n";
            out.write(name.getBytes());
            for (Pair pair1 : docFromFN.getArrayList()) {
                String line;
                if (pair1.getRight() instanceof List) {
                    line = pair1.getLeft() + "\n";
                    out.write(line.getBytes());
                    for (Pair pair2 : (List)pair1.getRight()) {
                        if (pair2.getRight() instanceof List) {
                            line = "\t" + pair2.getLeft() + "\n";
                            out.write(line.getBytes());
                            for (Pair pair3 : (List)pair2.getRight()) {
                                if (pair3.getRight() instanceof List) {
                                    line = "\t\t" + pair3.getLeft() + "\n";
                                    out.write(line.getBytes());
                                    continue;
                                }
                                line = "\t\t" + pair3.getLeft() + " " + pair3.getRight() + "\n";
                                out.write(line.getBytes());
                            }
                            continue;
                        }
                        line = "\t" + pair2.getLeft() + " " + pair2.getRight() + "\n";
                        out.write(line.getBytes());
                    }
                    continue;
                }
                line = pair1.getLeft() + " " + pair1.getRight() + "\n";
                out.write(line.getBytes());
            }
            out.flush();
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        piritSvc112.close();
    }

    class SendPacketThread
    extends Thread {
        StringBuilder packet = null;

        SendPacketThread(StringBuilder packet) {
            this.packet = packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DataPort dataPort = PiritConnector.this.dataPort;
                synchronized (dataPort) {
                    byte[] data = this.packet.toString().getBytes(PiritConnector.this.encoding);
                    data[5] = (byte)PiritConnector.this.sendId;
                    PiritConnector.this.dataPort.writeBytes(data);
                }
            }
            catch (Exception e) {
                PiritConnector.this.Log.error((Object)"", (Throwable)e);
            }
        }
    }
}

