/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector;

public class FnDocData {
    private final String FS = "\u001c";
    private String dateDoc = "";
    private String numberFN = "";
    private String recOFD = "";
    private String hexData = "";
    private int startIndex = 0;

    public FnDocData(String hexData) {
        this.hexData = hexData;
        this.startIndex = hexData.indexOf("\u001c");
        this.makeDataFromHexFn();
        this.makeNumberFNFromHexFn();
        this.makeOFDrecData();
    }

    private void makeDataFromHexFn() {
        String year = FnDocData.hexToDecimal(this.hexData.substring(this.startIndex + 1, this.startIndex + 3));
        String month = FnDocData.hexToDecimal(this.hexData.substring(this.startIndex + 3, this.startIndex + 5));
        String day = FnDocData.hexToDecimal(this.hexData.substring(this.startIndex + 5, this.startIndex + 7));
        String hours = FnDocData.hexToDecimal(this.hexData.substring(this.startIndex + 7, this.startIndex + 9));
        String mins = FnDocData.hexToDecimal(this.hexData.substring(this.startIndex + 9, this.startIndex + 11));
        this.dateDoc = day + "." + month + "." + year + " " + hours + ":" + mins;
    }

    private void makeNumberFNFromHexFn() {
        this.numberFN = FnDocData.hexToDecimal(this.hexData.substring(this.startIndex + 11, this.startIndex + 15));
    }

    private void makeOFDrecData() {
        this.recOFD = FnDocData.hexToDecimal(this.hexData.substring(this.startIndex + 15, this.startIndex + 33));
    }

    public String getFullDoc() {
        return "date = " + this.dateDoc + " FN number = " + this.numberFN + " OFD data = " + this.recOFD;
    }

    public static String hexToDecimal(String hex) {
        String digits = "0123456789ABCDEF";
        String result = "";
        hex = hex.toUpperCase();
        int val = 0;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c == '0') continue;
            int d = digits.indexOf(c);
            val = 16 * val + d;
        }
        result = val < 10 ? "0" + String.valueOf(val) : String.valueOf(val);
        return result;
    }

    public String getDateDoc() {
        return this.dateDoc;
    }

    public String getNumberFN() {
        return this.numberFN;
    }

    public String getRecOFD() {
        return this.recOFD;
    }
}

