/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector;

import java.math.BigInteger;

public class DriverUtil {
    private final String FS = "\u001c";
    private String dateDoc = "";
    private String numberFN = "";
    private String recOFD = "";
    private String hexData = "";
    private int startIndex = 0;

    public DriverUtil(String hexData) {
        this.hexData = hexData;
        this.startIndex = hexData.indexOf("\u001c");
        this.makeDataFromHexFn();
        this.makeNumberFNFromHexFn();
        this.makeOFDrecData();
    }

    private void makeDataFromHexFn() {
        String year = DriverUtil.hexToDecimal(this.hexData.substring(this.startIndex + 1, this.startIndex + 3));
        String month = DriverUtil.hexToDecimal(this.hexData.substring(this.startIndex + 3, this.startIndex + 5));
        String day = DriverUtil.hexToDecimal(this.hexData.substring(this.startIndex + 5, this.startIndex + 7));
        String hours = DriverUtil.hexToDecimal(this.hexData.substring(this.startIndex + 7, this.startIndex + 9));
        String mins = DriverUtil.hexToDecimal(this.hexData.substring(this.startIndex + 9, this.startIndex + 11));
        this.dateDoc = day + "." + month + "." + year + " " + hours + ":" + mins;
    }

    private void makeNumberFNFromHexFn() {
        this.numberFN = DriverUtil.hexToDecimal(this.hexData.substring(this.startIndex + 11, this.startIndex + 15));
    }

    private void makeOFDrecData() {
        this.recOFD = DriverUtil.hexToDecimal(this.hexData.substring(this.startIndex + 15, this.startIndex + 33));
    }

    public String getFullDoc() {
        return "date = " + this.dateDoc + " FN number = " + this.numberFN + " OFD data = " + this.recOFD;
    }

    public static String revertHEX(String data) {
        StringBuilder strTLVtagBuilder = new StringBuilder();
        String strTLVtag = data;
        if (strTLVtag.length() < 4) {
            strTLVtagBuilder.append(0);
        }
        strTLVtagBuilder.append(strTLVtag);
        String strTLVtagRevers = strTLVtagBuilder.substring(2, 4);
        return strTLVtagRevers + strTLVtagBuilder.substring(0, 2);
    }

    public static String revertHEX3(String data) {
        StringBuilder strTLVtagBuilder = new StringBuilder();
        String strTLVtag = data;
        int i = data.length();
        while (i > 0) {
            strTLVtagBuilder.append(strTLVtag.substring(i -= 2, i + 2));
        }
        return strTLVtagBuilder.toString();
    }

    public static String unHex(String arg) {
        String str = "";
        for (int i = 0; i < arg.length(); i += 2) {
            String s = arg.substring(i, i + 2);
            int decimal = Integer.parseInt(s, 16);
            str = str + (char)decimal;
        }
        return str;
    }

    public static String hexToDecimal(String hex) {
        if (hex == null) {
            return "";
        }
        String digits = "0123456789ABCDEF";
        String result = "";
        hex = hex.toUpperCase();
        int val = 0;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            int d = digits.indexOf(c);
            val = 16 * val + d;
        }
        result = val < 10 ? "0" + String.valueOf(val) : String.valueOf(val);
        return result;
    }

    public static String fpdHexToDecimal(String hex) {
        return new BigInteger(hex, 16).toString(10);
    }

    public static String doubleToStringPacket(Double value) {
        return String.format("%.3f", value).replace(',', '.');
    }

    public String getDateDoc() {
        return this.dateDoc;
    }

    public String getNumberFN() {
        return this.numberFN;
    }

    public String getRecOFD() {
        return this.recOFD;
    }
}

