/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.pos.fiscalprinter.jpos.pirit.connector;

import java.text.SimpleDateFormat;
import java.util.Date;
import ru.crystals.pos.fiscalprinter.jpos.pirit.connector.DriverUtil;

public class DataPacket {
    private StringBuilder data = new StringBuilder();
    private final String FS = "\u001c";

    public DataPacket() {
    }

    public DataPacket(String data) {
        this.data.append(data);
    }

    public void clear() {
        this.data = new StringBuilder();
    }

    public String getDataBuffer() {
        return this.data.toString();
    }

    public int getCountValue() {
        int beginIndex = 0;
        int endIndex = this.data.indexOf("\u001c", beginIndex);
        int count = 0;
        while (endIndex >= beginIndex) {
            beginIndex = endIndex + 1;
            endIndex = this.data.indexOf("\u001c", beginIndex);
            ++count;
        }
        return count;
    }

    public int getLength() {
        return this.data.length();
    }

    public void putStringValue(String value) {
        if (value != null) {
            this.data.append(value + "\u001c");
        } else {
            this.data.append("\u001c");
        }
    }

    public String getStringValue(int Index) throws Exception {
        int beginIndex = 0;
        int endIndex = this.data.indexOf("\u001c", beginIndex);
        int tmpIndex = 0;
        String subresult = "";
        while (endIndex >= beginIndex) {
            if (tmpIndex == Index) {
                subresult = this.data.substring(beginIndex, endIndex);
                return subresult;
            }
            beginIndex = endIndex + 1;
            endIndex = this.data.indexOf("\u001c", beginIndex);
            ++tmpIndex;
        }
        throw new Exception("Error parse of data: Index=" + Index + " out of bound");
    }

    public void putDateValue(Date value) {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        this.data.append(df.format(value) + "\u001c");
    }

    public Date getDateValue(int Index) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        return df.parse(this.getStringValue(Index));
    }

    public String getDateValueFullFormat() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        Date resultDate = df.parse(this.getStringValue(0));
        df = new SimpleDateFormat("ddMMyyyyhhmm");
        String result = df.format(resultDate);
        String time = this.data.substring(7, 11);
        result = result.substring(0, 8);
        return result + time;
    }

    public String getDateValueShiftFormat() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.data.substring(3, 5));
        sb.append(".");
        sb.append(this.data.substring(5, 7));
        sb.append(".");
        sb.append(20);
        sb.append(this.data.substring(7, 9));
        sb.append("-");
        sb.append(this.data.substring(10, 12));
        sb.append(":");
        sb.append(this.data.substring(12, 14));
        sb.append(":");
        sb.append(this.data.substring(14, 16));
        return sb.toString();
    }

    public String getDateValueShiftEndFormat() throws Exception {
        StringBuilder sb = new StringBuilder();
        String tmpDate = this.getStringValue(1);
        String tmpTime = this.getStringValue(2);
        sb.append(tmpDate.substring(0, 2));
        sb.append(".");
        sb.append(tmpDate.substring(2, 4));
        sb.append(".");
        sb.append(20);
        sb.append(tmpDate.substring(4, 6));
        sb.append("-");
        sb.append(tmpTime.substring(0, 2));
        sb.append(":");
        sb.append(tmpTime.substring(2, 4));
        sb.append(":");
        sb.append(tmpTime.substring(4, 6));
        return sb.toString();
    }

    public void putTimeValue(Date value) {
        SimpleDateFormat df = new SimpleDateFormat("HHmmss");
        this.data.append(df.format(value) + "\u001c");
    }

    public Date getTimeValue(int Index) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("HHmmss");
        return df.parse(this.getStringValue(Index));
    }

    public Date getDateTimeValue(int iDate, int iTime) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyyHHmmss");
        return df.parse(this.getStringValue(iDate) + this.getStringValue(iTime));
    }

    public void putLongValue(Long value) {
        if (value != null) {
            this.data.append(value + "\u001c");
        } else {
            this.data.append("\u001c");
        }
    }

    public long getLongValue(int Index) throws Exception {
        return Long.parseLong(this.getStringValue(Index).replace(".", ""));
    }

    public void putDoubleValue(Double value) {
        if (value != null) {
            this.data.append(DriverUtil.doubleToStringPacket(value) + "\u001c");
        } else {
            this.data.append("\u001c");
        }
    }

    public String getFS() {
        return "\u001c";
    }

    public String toString() {
        return this.data.toString();
    }
}

